/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.time.Clock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

class RateLimitedAuthenticationStrategyTest {
    RateLimitedAuthenticationStrategyTest() {
    }

    @Test
    void shouldReturnSuccessForValidAttempt() {
        FakeClock clock = RateLimitedAuthenticationStrategyTest.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, 3);
        User user = new User.Builder("user", (Credential)SecurityTestUtils.credentialFor("right")).build();
        Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("right"))).isEqualTo((Object)AuthenticationResult.SUCCESS);
    }

    @Test
    void shouldReturnSuccessForValidAttemptWithUserId() {
        FakeClock clock = RateLimitedAuthenticationStrategyTest.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, 3);
        User user = new User.Builder("user", (Credential)SecurityTestUtils.credentialFor("right")).withId("id").build();
        Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("right"))).isEqualTo((Object)AuthenticationResult.SUCCESS);
    }

    @Test
    void shouldReturnFailureForInvalidAttempt() {
        FakeClock clock = RateLimitedAuthenticationStrategyTest.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, 3);
        User user = new User.Builder("user", (Credential)SecurityTestUtils.credentialFor("right")).build();
        Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("wrong"))).isEqualTo((Object)AuthenticationResult.FAILURE);
    }

    @Test
    void shouldNotSlowRequestRateOnLessThanMaxFailedAttempts() {
        FakeClock clock = RateLimitedAuthenticationStrategyTest.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, 3);
        User user = new User.Builder("user", (Credential)SecurityTestUtils.credentialFor("right")).build();
        Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("wrong"))).isEqualTo((Object)AuthenticationResult.FAILURE);
        Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("wrong"))).isEqualTo((Object)AuthenticationResult.FAILURE);
        Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("right"))).isEqualTo((Object)AuthenticationResult.SUCCESS);
    }

    @Test
    void shouldSlowRequestRateOnMultipleFailedAttempts() {
        RateLimitedAuthenticationStrategyTest.testSlowRequestRateOnMultipleFailedAttempts(3, Duration.ofSeconds(5L));
        RateLimitedAuthenticationStrategyTest.testSlowRequestRateOnMultipleFailedAttempts(1, Duration.ofSeconds(10L));
        RateLimitedAuthenticationStrategyTest.testSlowRequestRateOnMultipleFailedAttempts(6, Duration.ofMinutes(1L));
        RateLimitedAuthenticationStrategyTest.testSlowRequestRateOnMultipleFailedAttempts(42, Duration.ofMinutes(2L));
    }

    @Test
    void shouldSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid() {
        RateLimitedAuthenticationStrategyTest.testSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid(3, Duration.ofSeconds(5L));
        RateLimitedAuthenticationStrategyTest.testSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid(1, Duration.ofSeconds(11L));
        RateLimitedAuthenticationStrategyTest.testSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid(22, Duration.ofMinutes(2L));
        RateLimitedAuthenticationStrategyTest.testSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid(42, Duration.ofDays(4L));
    }

    private static void testSlowRequestRateOnMultipleFailedAttempts(int maxFailedAttempts, Duration lockDuration) {
        FakeClock clock = RateLimitedAuthenticationStrategyTest.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, maxFailedAttempts, lockDuration);
        User user = new User.Builder("user", (Credential)SecurityTestUtils.credentialFor("right")).build();
        for (int i = 0; i < maxFailedAttempts; ++i) {
            Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("wrong"))).isEqualTo((Object)AuthenticationResult.FAILURE);
        }
        Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("wrong"))).isEqualTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS);
        clock.forward(lockDuration.plus(1L, ChronoUnit.SECONDS));
        Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("wrong"))).isEqualTo((Object)AuthenticationResult.FAILURE);
    }

    private static void testSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid(int maxFailedAttempts, Duration lockDuration) {
        FakeClock clock = RateLimitedAuthenticationStrategyTest.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, maxFailedAttempts, lockDuration);
        User user = new User.Builder("user", (Credential)SecurityTestUtils.credentialFor("right")).build();
        for (int i = 0; i < maxFailedAttempts; ++i) {
            Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("wrong"))).isEqualTo((Object)AuthenticationResult.FAILURE);
        }
        Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("right"))).isEqualTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS);
        clock.forward(lockDuration.plus(1L, ChronoUnit.SECONDS));
        Assertions.assertThat((Comparable)authStrategy.authenticate(user, SecurityTestUtils.password("right"))).isEqualTo((Object)AuthenticationResult.SUCCESS);
    }

    @Test
    void shouldAllowUnlimitedFailedAttemptsWhenMaxFailedAttemptsIsZero() {
        RateLimitedAuthenticationStrategyTest.testUnlimitedFailedAuthAttempts(0);
    }

    @Test
    void shouldAllowUnlimitedFailedAttemptsWhenMaxFailedAttemptsIsNegative() {
        RateLimitedAuthenticationStrategyTest.testUnlimitedFailedAuthAttempts(-42);
    }

    private static void testUnlimitedFailedAuthAttempts(int maxFailedAttempts) {
        FakeClock clock = RateLimitedAuthenticationStrategyTest.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, maxFailedAttempts);
        User user = new User.Builder("user", (Credential)SecurityTestUtils.credentialFor("right")).build();
        int attempts = ThreadLocalRandom.current().nextInt(5, 100);
        for (int i = 0; i < attempts; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)AuthenticationResult.FAILURE, (Object)authStrategy.authenticate(user, SecurityTestUtils.password("wrong")));
        }
    }

    private static FakeClock getFakeClock() {
        return Clocks.fakeClock();
    }

    private static RateLimitedAuthenticationStrategy newAuthStrategy(Clock clock, int maxFailedAttempts) {
        Duration defaultLockDuration = (Duration)Config.defaults().get(GraphDatabaseSettings.auth_lock_time);
        return RateLimitedAuthenticationStrategyTest.newAuthStrategy(clock, maxFailedAttempts, defaultLockDuration);
    }

    private static RateLimitedAuthenticationStrategy newAuthStrategy(Clock clock, int maxFailedAttempts, Duration lockDuration) {
        return new RateLimitedAuthenticationStrategy(clock, lockDuration, maxFailedAttempts);
    }
}

