/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.server.security.auth.LegacyCredential;

class LegacyCredentialTest {
    LegacyCredentialTest() {
    }

    @Test
    void testMatchesPassword() {
        LegacyCredential credential = LegacyCredential.forPassword((String)"foo");
        Assertions.assertTrue((boolean)credential.matchesPassword("foo"));
        Assertions.assertFalse((boolean)credential.matchesPassword("fooo"));
        Assertions.assertFalse((boolean)credential.matchesPassword("fo"));
        Assertions.assertFalse((boolean)credential.matchesPassword("bar"));
    }

    @Test
    void testEquals() {
        LegacyCredential credential = LegacyCredential.forPassword((String)"foo");
        LegacyCredential sameCredential = new LegacyCredential(credential.salt(), credential.passwordHash());
        Assertions.assertEquals((Object)credential, (Object)sameCredential);
    }

    @Test
    void testInaccessibleCredentials() {
        LegacyCredential credential = new LegacyCredential(LegacyCredential.INACCESSIBLE.salt(), LegacyCredential.INACCESSIBLE.passwordHash());
        Assertions.assertEquals((Object)LegacyCredential.INACCESSIBLE, (Object)credential);
        Assertions.assertEquals((Object)LegacyCredential.INACCESSIBLE, (Object)credential);
        Assertions.assertEquals((Object)LegacyCredential.INACCESSIBLE, (Object)LegacyCredential.INACCESSIBLE);
        Assertions.assertNotEquals((Object)LegacyCredential.INACCESSIBLE, (Object)LegacyCredential.forPassword((String)""));
        Assertions.assertNotEquals((Object)LegacyCredential.INACCESSIBLE, (Object)LegacyCredential.forPassword((String)""));
        Assertions.assertFalse((boolean)LegacyCredential.INACCESSIBLE.matchesPassword(new String(new byte[0])));
        Assertions.assertFalse((boolean)LegacyCredential.INACCESSIBLE.matchesPassword("foo"));
        Assertions.assertFalse((boolean)LegacyCredential.INACCESSIBLE.matchesPassword(""));
    }
}

