/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.PrintStream;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.admin.security.SetDefaultAdminCommand;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.FileUserRepository;
import picocli.CommandLine;

class SetDefaultAdminCommandIT {
    private final FileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    private Path confDir;
    private Path homeDir;
    private PrintStream out;
    private PrintStream err;

    SetDefaultAdminCommandIT() {
    }

    @BeforeEach
    void setup() {
        Path graphDir = Path.of("neo4j", new String[0]);
        this.confDir = graphDir.resolveSibling("conf");
        this.homeDir = graphDir.resolveSibling("home");
        this.out = (PrintStream)Mockito.mock(PrintStream.class);
        this.err = (PrintStream)Mockito.mock(PrintStream.class);
    }

    @Test
    void shouldSetDefaultAdmin() throws Throwable {
        this.execute("jane");
        this.assertAdminIniFile("jane");
        ((PrintStream)Mockito.verify((Object)this.out)).println("default admin user set to 'jane'");
    }

    @Test
    void shouldOverwrite() throws Throwable {
        this.execute("jane");
        this.assertAdminIniFile("jane");
        this.execute("janette");
        this.assertAdminIniFile("janette");
        ((PrintStream)Mockito.verify((Object)this.out)).println("default admin user set to 'jane'");
        ((PrintStream)Mockito.verify((Object)this.out)).println("default admin user set to 'janette'");
    }

    private void assertAdminIniFile(String username) throws Throwable {
        Path adminIniFile = this.homeDir.resolve("data").resolve("dbms").resolve("admin.ini");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSystem.fileExists(adminIniFile));
        FileUserRepository userRepository = new FileUserRepository(this.fileSystem, adminIniFile, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        Assertions.assertThat((Iterable)userRepository.getAllUsernames()).contains((Object[])new String[]{username});
        userRepository.stop();
        userRepository.shutdown();
    }

    private void execute(String username) {
        SetDefaultAdminCommand command = new SetDefaultAdminCommand(new ExecutionContext(this.homeDir, this.confDir, this.out, this.err, this.fileSystem));
        CommandLine.populateCommand((Object)command, (String[])new String[]{username});
        command.execute();
    }
}

