/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.kernel.api.security.AuthToken;

public class SecurityTestUtils {
    private SecurityTestUtils() {
    }

    public static Map<String, Object> authToken(String username, String password) {
        return AuthToken.newBasicAuthToken((String)username, (String)password);
    }

    public static byte[] password(String passwordString) {
        return passwordString != null ? passwordString.getBytes(StandardCharsets.UTF_8) : null;
    }

    public static SystemGraphCredential credentialFor(String passwordString) {
        return SystemGraphCredential.createCredentialForPassword((byte[])SecurityTestUtils.password(passwordString), (SecureHasher)new SecureHasher());
    }
}

