/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph.versions;

import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.Log;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.ComponentVersion;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.util.Preconditions;

public class CommunitySecurityComponentVersion_0_35
extends KnownCommunitySecurityComponentVersion {
    private final UserRepository userRepository;

    public CommunitySecurityComponentVersion_0_35(Log log, UserRepository userRepository) {
        super(ComponentVersion.COMMUNITY_SECURITY_35, log);
        this.userRepository = userRepository;
    }

    @Override
    public boolean detected(Transaction tx) {
        if (CommunitySecurityComponentVersion_0_35.nodesWithLabelExist(tx, USER_LABEL) || this.getVersion(tx) != -1) {
            return false;
        }
        try {
            this.userRepository.start();
            return this.userRepository.numberOfUsers() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setupUsers(Transaction tx) {
        throw this.unsupported();
    }

    @Override
    public void updateInitialUserPassword(Transaction tx) {
        throw this.unsupported();
    }

    @Override
    public void upgradeSecurityGraph(Transaction tx, KnownCommunitySecurityComponentVersion latest) throws Exception {
        Preconditions.checkState((latest.version == ComponentVersion.LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION ? 1 : 0) != 0, (String)String.format("Latest version should be %s but was %s", ComponentVersion.LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION, latest.version));
        this.userRepository.start();
        ListSnapshot<User> users = this.userRepository.getSnapshot();
        if (!users.values().isEmpty()) {
            for (User user : users.values()) {
                this.addUser(tx, user.name(), user.credentials(), user.passwordChangeRequired(), user.hasFlag("is_suspended"));
            }
            String userString = users.values().size() == 1 ? "user" : "users";
            this.log.info("Completed migration of %s %s into system graph.", new Object[]{Integer.toString(users.values().size()), userString});
        } else {
            this.log.info("No users migrated from auth file into system graph.");
        }
        this.setVersionProperty(tx, latest.version);
    }
}

