/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.LegacyCredential;
import org.neo4j.server.security.auth.UserSerialization;
import org.neo4j.string.UTF8;

class UserSerializationTest {
    UserSerializationTest() {
    }

    @Test
    void shouldSerializeAndDeserialize() throws Exception {
        UserSerialization serialization = new UserSerialization();
        List<User> users = Arrays.asList(new User.Builder("Mike", (Credential)LegacyCredential.forPassword((String)"1234321")).withFlag("not_as_nice").build(), new User.Builder("Steve", (Credential)LegacyCredential.forPassword((String)"1234321")).build(), new User.Builder("steve.stevesson@WINDOMAIN", (Credential)LegacyCredential.forPassword((String)"1234321")).build(), new User.Builder("Bob", (Credential)LegacyCredential.forPassword((String)"0987654")).build());
        byte[] serialized = serialization.serialize(users);
        Assertions.assertThat((List)serialization.deserializeRecords(serialized)).isEqualTo(users);
    }

    @Test
    void shouldSerializeAndDeserializeSystemGraphCredentialPassword() throws Exception {
        UserSerialization serialization = new UserSerialization();
        SecureHasher hasher = new SecureHasher();
        List<User> users = Arrays.asList(new User.Builder("Mike", (Credential)SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"1234321"), (SecureHasher)hasher)).build(), new User.Builder("Steve", (Credential)SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"1234321"), (SecureHasher)hasher)).build(), new User.Builder("steve.stevesson@WINDOMAIN", (Credential)SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"1234321"), (SecureHasher)hasher)).build(), new User.Builder("Bob", (Credential)SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"0987654"), (SecureHasher)hasher)).build());
        byte[] serialized = serialization.serialize(users);
        List actual = serialization.deserializeRecords(serialized);
        Assertions.assertThat((int)actual.size()).isEqualTo(users.size());
        for (int i = 0; i < actual.size(); ++i) {
            User actualUser = (User)actual.get(i);
            User givenUser = users.get(i);
            Assertions.assertThat((String)actualUser.name()).isEqualTo(givenUser.name());
            Assertions.assertThat((String)actualUser.credentials().serialize()).isEqualTo(givenUser.credentials().serialize());
        }
    }

    @Test
    void shouldMaskAndUnmaskSerializedSystemGraphCredential() throws Exception {
        SecureHasher hasher = new SecureHasher();
        List<User> users = Arrays.asList(new User.Builder("Mike", (Credential)SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"1234321"), (SecureHasher)hasher)).build(), new User.Builder("Steve", (Credential)SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"1234321"), (SecureHasher)hasher)).build(), new User.Builder("steve.stevesson@WINDOMAIN", (Credential)SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"1234321"), (SecureHasher)hasher)).build(), new User.Builder("Bob", (Credential)SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"0987654"), (SecureHasher)hasher)).build());
        for (User user : users) {
            String serialized = user.credentials().serialize();
            String masked = SystemGraphCredential.maskSerialized((String)serialized);
            Assertions.assertThat((String)serialized).isEqualTo(SystemGraphCredential.serialize((byte[])masked.getBytes()));
        }
    }

    @Test
    void shouldMaskAndUnmaskSerializedCredentialsMissingIterations() throws Exception {
        List<User> users = Arrays.asList(new User.Builder("Mike", (Credential)LegacyCredential.forPassword((byte[])UTF8.encode((String)"1234321"))).build(), new User.Builder("Steve", (Credential)LegacyCredential.forPassword((byte[])UTF8.encode((String)"1234321"))).build(), new User.Builder("steve.stevesson@WINDOMAIN", (Credential)LegacyCredential.forPassword((byte[])UTF8.encode((String)"1234321"))).build(), new User.Builder("Bob", (Credential)LegacyCredential.forPassword((byte[])UTF8.encode((String)"0987654"))).build());
        for (User user : users) {
            String serialized = user.credentials().serialize();
            String serializedWithoutIterations = serialized.substring(0, serialized.lastIndexOf(","));
            String masked = SystemGraphCredential.maskSerialized((String)serializedWithoutIterations);
            Assertions.assertThat((String)serialized).isEqualTo(SystemGraphCredential.serialize((byte[])masked.getBytes()));
        }
    }

    @Test
    void shouldReadV1SerializationFormat() throws Exception {
        UserSerialization serialization = new UserSerialization();
        byte[] salt1 = new byte[]{-91, 67};
        byte[] hash1 = new byte[]{-2, 0, 86, -61, 126};
        byte[] salt2 = new byte[]{52, -92};
        byte[] hash2 = new byte[]{14, 31, -1, -62, 62};
        List deserialized = serialization.deserializeRecords(UTF8.encode((String)"Mike:SHA-256,FE0056C37E,A543:\nSteve:SHA-256,FE0056C37E,A543:nice_guy,password_change_required\nBob:SHA-256,0E1FFFC23E,34A4:password_change_required\n"));
        Assertions.assertThat((List)deserialized).isEqualTo(Arrays.asList(new User.Builder("Mike", (Credential)new LegacyCredential(salt1, hash1)).build(), new User.Builder("Steve", (Credential)new LegacyCredential(salt1, hash1)).withRequiredPasswordChange(true).withFlag("nice_guy").build(), new User.Builder("Bob", (Credential)new LegacyCredential(salt2, hash2)).withRequiredPasswordChange(true).build()));
    }
}

