/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.apache.shiro.authc.AuthenticationInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.server.security.auth.ShiroAuthenticationInfo;

class ShiroAuthenticationInfoTest {
    private final ShiroAuthenticationInfo successInfo = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.SUCCESS);
    private final ShiroAuthenticationInfo failureInfo = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
    private final ShiroAuthenticationInfo tooManyAttemptsInfo = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.TOO_MANY_ATTEMPTS);
    private final ShiroAuthenticationInfo pwChangeRequiredInfo = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.PASSWORD_CHANGE_REQUIRED);

    ShiroAuthenticationInfoTest() {
    }

    @Test
    void shouldChangeMergeMatrixIfAuthenticationResultEnumChanges() {
        Assertions.assertEquals((int)AuthenticationResult.SUCCESS.ordinal(), (int)0);
        Assertions.assertEquals((int)AuthenticationResult.FAILURE.ordinal(), (int)1);
        Assertions.assertEquals((int)AuthenticationResult.TOO_MANY_ATTEMPTS.ordinal(), (int)2);
        Assertions.assertEquals((int)AuthenticationResult.PASSWORD_CHANGE_REQUIRED.ordinal(), (int)3);
        Assertions.assertEquals((int)4, (int)AuthenticationResult.values().length);
    }

    @Test
    void shouldMergeTwoSuccessToSameValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.SUCCESS);
        info.merge((AuthenticationInfo)this.successInfo);
        Assertions.assertEquals((Object)AuthenticationResult.SUCCESS, (Object)info.getAuthenticationResult());
    }

    @Test
    void shouldMergeTwoFailureToSameValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
        info.merge((AuthenticationInfo)this.failureInfo);
        Assertions.assertEquals((Object)AuthenticationResult.FAILURE, (Object)info.getAuthenticationResult());
    }

    @Test
    void shouldMergeTwoTooManyAttemptsToSameValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.TOO_MANY_ATTEMPTS);
        info.merge((AuthenticationInfo)this.tooManyAttemptsInfo);
        Assertions.assertEquals((Object)AuthenticationResult.TOO_MANY_ATTEMPTS, (Object)info.getAuthenticationResult());
    }

    @Test
    void shouldMergeTwoPasswordChangeRequiredToSameValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
        info.merge((AuthenticationInfo)this.pwChangeRequiredInfo);
        Assertions.assertEquals((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED, (Object)info.getAuthenticationResult());
    }

    @Test
    void shouldMergeFailureWithSuccessToNewValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
        info.merge((AuthenticationInfo)this.successInfo);
        Assertions.assertEquals((Object)AuthenticationResult.SUCCESS, (Object)info.getAuthenticationResult());
    }

    @Test
    void shouldMergeFailureWithTooManyAttemptsToNewValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
        info.merge((AuthenticationInfo)this.tooManyAttemptsInfo);
        Assertions.assertEquals((Object)AuthenticationResult.TOO_MANY_ATTEMPTS, (Object)info.getAuthenticationResult());
    }

    @Test
    void shouldMergeFailureWithPasswordChangeRequiredToNewValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
        info.merge((AuthenticationInfo)this.pwChangeRequiredInfo);
        Assertions.assertEquals((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED, (Object)info.getAuthenticationResult());
    }

    @Test
    void shouldMergeToNewValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
        info.merge((AuthenticationInfo)this.pwChangeRequiredInfo);
        Assertions.assertEquals((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED, (Object)info.getAuthenticationResult());
    }
}

