/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.admin.security.SetDefaultAdminCommand;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.LegacyCredential;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import picocli.CommandLine;

@EphemeralTestDirectoryExtension
class SetDefaultAdminCommandTest {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDir;
    private SetDefaultAdminCommand command;
    private Path adminIniFile;

    SetDefaultAdminCommandTest() {
    }

    @BeforeEach
    void setup() throws IOException, InvalidArgumentsException {
        this.command = new SetDefaultAdminCommand(new ExecutionContext(this.testDir.directory("home"), this.testDir.directory("conf"), (PrintStream)Mockito.mock(PrintStream.class), (PrintStream)Mockito.mock(PrintStream.class), this.fileSystem));
        Config config = this.command.loadNeo4jConfig();
        FileUserRepository users = CommunitySecurityModule.getUserRepository((Config)config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fileSystem);
        users.create(new User.Builder("jake", (Credential)LegacyCredential.forPassword((String)"123")).withRequiredPasswordChange(false).build());
        this.adminIniFile = CommunitySecurityModule.getUserRepositoryFile((Config)config).resolveSibling("admin.ini");
    }

    @Test
    void printUsageHelp() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream out = new PrintStream(baos);){
            CommandLine.usage((Object)this.command, (PrintStream)new PrintStream(out), (CommandLine.Help.Ansi)CommandLine.Help.Ansi.OFF);
        }
        Assertions.assertThat((String)baos.toString().trim()).isEqualTo(String.format("USAGE%n%nset-default-admin [--expand-commands] [--verbose] <username>%n%nDESCRIPTION%n%nSets the default admin user.%nThis user will be granted the admin role on startup if the system has no roles.%n%nPARAMETERS%n%n      <username>%n%nOPTIONS%n%n      --verbose           Enable verbose output.%n      --expand-commands   Allow command expansion in config value evaluation.", new Object[0]));
    }

    @Test
    void shouldSetDefaultAdmin() throws Throwable {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fileSystem.fileExists(this.adminIniFile));
        CommandLine.populateCommand((Object)this.command, (String[])new String[]{"jake"});
        this.command.execute();
        this.assertAdminIniFile("jake");
    }

    private void assertAdminIniFile(String username) throws Throwable {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSystem.fileExists(this.adminIniFile));
        FileUserRepository userRepository = new FileUserRepository(this.fileSystem, this.adminIniFile, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        Assertions.assertThat((Iterable)userRepository.getAllUsernames()).contains((Object[])new String[]{username});
    }
}

