/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.admin.security.SetInitialPasswordCommand;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import picocli.CommandLine;

@EphemeralTestDirectoryExtension
class SetInitialPasswordCommandTest {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDir;
    private SetInitialPasswordCommand command;
    private File authInitFile;

    SetInitialPasswordCommandTest() {
    }

    @BeforeEach
    void setup() {
        this.command = new SetInitialPasswordCommand(new ExecutionContext(this.testDir.directory("home", new String[0]).toPath(), this.testDir.directory("conf", new String[0]).toPath(), (PrintStream)Mockito.mock(PrintStream.class), (PrintStream)Mockito.mock(PrintStream.class), this.fileSystem));
        this.authInitFile = CommunitySecurityModule.getInitialUserRepositoryFile((Config)this.command.loadNeo4jConfig());
        CommunitySecurityModule.getUserRepositoryFile((Config)this.command.loadNeo4jConfig());
    }

    @Test
    void printUsageHelp() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream out = new PrintStream(baos);){
            CommandLine.usage((Object)this.command, (PrintStream)new PrintStream(out));
        }
        Assertions.assertThat((String)baos.toString().trim()).isEqualTo(String.format("USAGE%n%nset-initial-password [--require-password-change] [--verbose] <password>%n%nDESCRIPTION%n%nSets the initial password of the initial admin user ('neo4j'). And removes the%nrequirement to change password on first login.%n%nPARAMETERS%n%n      <password>%n%nOPTIONS%n%n      --verbose    Enable verbose output.%n      --require-password-change%n                   Require the user to change their password on first login.", new Object[0]));
    }

    @Test
    void shouldSetInitialPassword() throws Throwable {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fileSystem.fileExists(this.authInitFile));
        CommandLine.populateCommand((Object)this.command, (String[])new String[]{"123"});
        this.command.execute();
        this.assertAuthIniFile("123");
    }

    @Test
    void shouldOverwriteInitialPasswordFileIfExists() throws Throwable {
        this.fileSystem.mkdirs(this.authInitFile.getParentFile());
        this.fileSystem.write(this.authInitFile);
        CommandLine.populateCommand((Object)this.command, (String[])new String[]{"123"});
        this.command.execute();
        this.assertAuthIniFile("123");
    }

    @Test
    void shouldWorkAlsoWithSamePassword() throws Throwable {
        CommandLine.populateCommand((Object)this.command, (String[])new String[]{"neo4j"});
        this.command.execute();
        this.assertAuthIniFile("neo4j");
    }

    private void assertAuthIniFile(String password) throws Throwable {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSystem.fileExists(this.authInitFile));
        FileUserRepository userRepository = new FileUserRepository(this.fileSystem, this.authInitFile, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        User neo4j = userRepository.getUserByName("neo4j");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)neo4j);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)neo4j.credentials().matchesPassword(password));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)neo4j.hasFlag("password_change_required"));
    }
}

