/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.LegacyCredential;

public class UserTest {
    @Test
    public void shouldBuildImmutableUser() {
        LegacyCredential abc = LegacyCredential.forPassword((String)"123abc");
        LegacyCredential fruit = LegacyCredential.forPassword((String)"fruit");
        User u1 = new User.Builder("Steve", (Credential)abc).build();
        User u2 = new User.Builder("Steve", (Credential)fruit).withRequiredPasswordChange(true).withFlag("nice_guy").build();
        MatcherAssert.assertThat((Object)u1, (Matcher)CoreMatchers.equalTo((Object)u1));
        MatcherAssert.assertThat((Object)u1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)u2)));
        User u1AsU2 = u1.augment().withCredentials((Credential)fruit).withRequiredPasswordChange(true).withFlag("nice_guy").build();
        MatcherAssert.assertThat((Object)u1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)u1AsU2)));
        MatcherAssert.assertThat((Object)u2, (Matcher)CoreMatchers.equalTo((Object)u1AsU2));
        User u2AsU1 = u2.augment().withCredentials((Credential)abc).withRequiredPasswordChange(false).withoutFlag("nice_guy").build();
        MatcherAssert.assertThat((Object)u2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)u2AsU1)));
        MatcherAssert.assertThat((Object)u1, (Matcher)CoreMatchers.equalTo((Object)u2AsU1));
        MatcherAssert.assertThat((Object)u1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)u2)));
    }
}

