/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.time.Clock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ThreadLocalRandom;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.BasicAuthManagerTest;
import org.neo4j.server.security.auth.LegacyCredential;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class RateLimitedAuthenticationStrategyTest {
    @Test
    public void shouldReturnSuccessForValidAttempt() {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, 3);
        User user = new User.Builder("user", (Credential)LegacyCredential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("right")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldReturnFailureForInvalidAttempt() {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, 3);
        User user = new User.Builder("user", (Credential)LegacyCredential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("wrong")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldNotSlowRequestRateOnLessThanMaxFailedAttempts() {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, 3);
        User user = new User.Builder("user", (Credential)LegacyCredential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("wrong")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("wrong")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("right")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldSlowRequestRateOnMultipleFailedAttempts() {
        this.testSlowRequestRateOnMultipleFailedAttempts(3, Duration.ofSeconds(5L));
        this.testSlowRequestRateOnMultipleFailedAttempts(1, Duration.ofSeconds(10L));
        this.testSlowRequestRateOnMultipleFailedAttempts(6, Duration.ofMinutes(1L));
        this.testSlowRequestRateOnMultipleFailedAttempts(42, Duration.ofMinutes(2L));
    }

    @Test
    public void shouldSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid() {
        this.testSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid(3, Duration.ofSeconds(5L));
        this.testSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid(1, Duration.ofSeconds(11L));
        this.testSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid(22, Duration.ofMinutes(2L));
        this.testSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid(42, Duration.ofDays(4L));
    }

    private void testSlowRequestRateOnMultipleFailedAttempts(int maxFailedAttempts, Duration lockDuration) {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, maxFailedAttempts, lockDuration);
        User user = new User.Builder("user", (Credential)LegacyCredential.forPassword((String)"right")).build();
        for (int i = 0; i < maxFailedAttempts; ++i) {
            Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("wrong")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        }
        Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("wrong")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS));
        clock.forward(lockDuration.plus(1L, ChronoUnit.SECONDS));
        Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("wrong")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    private void testSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid(int maxFailedAttempts, Duration lockDuration) {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, maxFailedAttempts, lockDuration);
        User user = new User.Builder("user", (Credential)LegacyCredential.forPassword((String)"right")).build();
        for (int i = 0; i < maxFailedAttempts; ++i) {
            Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("wrong")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        }
        Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("right")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS));
        clock.forward(lockDuration.plus(1L, ChronoUnit.SECONDS));
        Assert.assertThat((Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("right")), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldAllowUnlimitedFailedAttemptsWhenMaxFailedAttemptsIsZero() {
        this.testUnlimitedFailedAuthAttempts(0);
    }

    @Test
    public void shouldAllowUnlimitedFailedAttemptsWhenMaxFailedAttemptsIsNegative() {
        this.testUnlimitedFailedAuthAttempts(-42);
    }

    private void testUnlimitedFailedAuthAttempts(int maxFailedAttempts) {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = RateLimitedAuthenticationStrategyTest.newAuthStrategy((Clock)clock, maxFailedAttempts);
        User user = new User.Builder("user", (Credential)LegacyCredential.forPassword((String)"right")).build();
        int attempts = ThreadLocalRandom.current().nextInt(5, 100);
        for (int i = 0; i < attempts; ++i) {
            Assert.assertEquals((Object)AuthenticationResult.FAILURE, (Object)authStrategy.authenticate(user, BasicAuthManagerTest.password("wrong")));
        }
    }

    private FakeClock getFakeClock() {
        return Clocks.fakeClock();
    }

    private static RateLimitedAuthenticationStrategy newAuthStrategy(Clock clock, int maxFailedAttempts) {
        Duration defaultLockDuration = (Duration)Config.defaults().get(GraphDatabaseSettings.auth_lock_time);
        return RateLimitedAuthenticationStrategyTest.newAuthStrategy(clock, maxFailedAttempts, defaultLockDuration);
    }

    private static RateLimitedAuthenticationStrategy newAuthStrategy(Clock clock, int maxFailedAttempts, Duration lockDuration) {
        return new RateLimitedAuthenticationStrategy(clock, lockDuration, maxFailedAttempts);
    }
}

