/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.security.auth.LegacyCredential;

public class LegacyCredentialTest {
    @Test
    public void testMatchesPassword() {
        LegacyCredential credential = LegacyCredential.forPassword((String)"foo");
        Assert.assertTrue((boolean)credential.matchesPassword("foo"));
        Assert.assertFalse((boolean)credential.matchesPassword("fooo"));
        Assert.assertFalse((boolean)credential.matchesPassword("fo"));
        Assert.assertFalse((boolean)credential.matchesPassword("bar"));
    }

    @Test
    public void testEquals() {
        LegacyCredential credential = LegacyCredential.forPassword((String)"foo");
        LegacyCredential sameCredential = new LegacyCredential(credential.salt(), credential.passwordHash());
        Assert.assertEquals((Object)credential, (Object)sameCredential);
    }

    @Test
    public void testInaccessibleCredentials() {
        LegacyCredential credential = new LegacyCredential(LegacyCredential.INACCESSIBLE.salt(), LegacyCredential.INACCESSIBLE.passwordHash());
        Assert.assertEquals((Object)LegacyCredential.INACCESSIBLE, (Object)credential);
        Assert.assertEquals((Object)credential, (Object)LegacyCredential.INACCESSIBLE);
        Assert.assertEquals((Object)LegacyCredential.INACCESSIBLE, (Object)LegacyCredential.INACCESSIBLE);
        Assert.assertNotEquals((Object)LegacyCredential.INACCESSIBLE, (Object)LegacyCredential.forPassword((String)""));
        Assert.assertNotEquals((Object)LegacyCredential.forPassword((String)""), (Object)LegacyCredential.INACCESSIBLE);
        Assert.assertFalse((boolean)LegacyCredential.INACCESSIBLE.matchesPassword(new String(new byte[0])));
        Assert.assertFalse((boolean)LegacyCredential.INACCESSIBLE.matchesPassword("foo"));
        Assert.assertFalse((boolean)LegacyCredential.INACCESSIBLE.matchesPassword(""));
    }
}

