/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.File;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.api.security.UserManager;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.security.auth.AuthProcedures;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.time.Clocks;

public class CommunitySecurityModule
extends SecurityModule {
    public static final String COMMUNITY_SECURITY_MODULE_ID = "community-security-module";
    public static final String USER_STORE_FILENAME = "auth";
    public static final String INITIAL_USER_STORE_FILENAME = "auth.ini";

    public CommunitySecurityModule() {
        super(COMMUNITY_SECURITY_MODULE_ID, new String[0]);
    }

    public void setup(SecurityModule.Dependencies dependencies) throws KernelException {
        Config config = dependencies.config();
        Procedures procedures = dependencies.procedures();
        LogProvider logProvider = dependencies.logService().getUserLogProvider();
        FileSystemAbstraction fileSystem = dependencies.fileSystem();
        FileUserRepository userRepository = CommunitySecurityModule.getUserRepository(config, logProvider, fileSystem);
        FileUserRepository initialUserRepository = CommunitySecurityModule.getInitialUserRepository(config, logProvider, fileSystem);
        BasicPasswordPolicy passwordPolicy = new BasicPasswordPolicy();
        BasicAuthManager authManager = new BasicAuthManager(userRepository, passwordPolicy, Clocks.systemClock(), initialUserRepository, config);
        dependencies.lifeSupport().add((Lifecycle)dependencies.dependencySatisfier().satisfyDependency((Object)authManager));
        procedures.registerComponent(UserManager.class, ctx -> authManager, false);
        procedures.registerProcedure(AuthProcedures.class);
    }

    public static FileUserRepository getUserRepository(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) {
        return new FileUserRepository(fileSystem, CommunitySecurityModule.getUserRepositoryFile(config), logProvider);
    }

    public static FileUserRepository getInitialUserRepository(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) {
        return new FileUserRepository(fileSystem, CommunitySecurityModule.getInitialUserRepositoryFile(config), logProvider);
    }

    public static File getUserRepositoryFile(Config config) {
        return CommunitySecurityModule.getUserRepositoryFile(config, USER_STORE_FILENAME);
    }

    public static File getInitialUserRepositoryFile(Config config) {
        return CommunitySecurityModule.getUserRepositoryFile(config, INITIAL_USER_STORE_FILENAME);
    }

    private static File getUserRepositoryFile(Config config, String fileName) {
        File authStoreDir = (File)config.get(DatabaseManagementSystemSettings.auth_store_directory);
        File userStoreFile = (File)config.get(GraphDatabaseSettings.auth_store);
        if (userStoreFile == null) {
            userStoreFile = new File(authStoreDir, fileName);
        }
        return userStoreFile;
    }
}

