/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.time.Clocks;

public class SecurityContextDescriptionTest {
    private BasicAuthManager manager;
    private SecurityContext context;

    @Before
    public void setup() throws Throwable {
        this.manager = new BasicAuthManager((UserRepository)new InMemoryUserRepository(), (PasswordPolicy)new BasicPasswordPolicy(), Clocks.systemClock(), (UserRepository)new InMemoryUserRepository(), Config.defaults());
        this.manager.init();
        this.manager.start();
        this.manager.newUser("johan", "bar", false);
        this.context = this.manager.login(SecurityTestUtils.authToken("johan", "bar")).authorize(s -> -1);
    }

    @After
    public void teardown() throws Throwable {
        this.manager.stop();
        this.manager.shutdown();
    }

    @Test
    public void shouldMakeNiceDescription() {
        Assert.assertThat((Object)this.context.description(), (Matcher)Matchers.equalTo((Object)"user 'johan' with FULL"));
    }

    @Test
    public void shouldMakeNiceDescriptionWithMode() {
        SecurityContext modified = this.context.withMode((AccessMode)AccessMode.Static.WRITE);
        Assert.assertThat((Object)modified.description(), (Matcher)Matchers.equalTo((Object)"user 'johan' with WRITE"));
    }

    @Test
    public void shouldMakeNiceDescriptionRestricted() {
        SecurityContext restricted = this.context.withMode((AccessMode)new RestrictedAccessMode(this.context.mode(), (AccessMode)AccessMode.Static.READ));
        Assert.assertThat((Object)restricted.description(), (Matcher)Matchers.equalTo((Object)"user 'johan' with FULL restricted to READ"));
    }

    @Test
    public void shouldMakeNiceDescriptionOverridden() {
        SecurityContext overridden = this.context.withMode((AccessMode)new OverriddenAccessMode(this.context.mode(), (AccessMode)AccessMode.Static.READ));
        Assert.assertThat((Object)overridden.description(), (Matcher)Matchers.equalTo((Object)"user 'johan' with FULL overridden by READ"));
    }

    @Test
    public void shouldMakeNiceDescriptionAuthDisabled() {
        SecurityContext disabled = SecurityContext.AUTH_DISABLED;
        Assert.assertThat((Object)disabled.description(), (Matcher)Matchers.equalTo((Object)"AUTH_DISABLED with FULL"));
    }

    @Test
    public void shouldMakeNiceDescriptionAuthDisabledAndRestricted() {
        SecurityContext disabled = SecurityContext.AUTH_DISABLED;
        SecurityContext restricted = disabled.withMode((AccessMode)new RestrictedAccessMode(disabled.mode(), (AccessMode)AccessMode.Static.READ));
        Assert.assertThat((Object)restricted.description(), (Matcher)Matchers.equalTo((Object)"AUTH_DISABLED with FULL restricted to READ"));
    }
}

