/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.time.Clock;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class RateLimitedAuthenticationStrategyTest {
    @Test
    public void shouldReturnSuccessForValidAttempt() {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldReturnFailureForInvalidAttempt() {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldNotSlowRequestRateOnLessThanMaxFailedAttempts() {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldSlowRequestRateOnMultipleFailedAttempts() {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS));
        clock.forward(5L, TimeUnit.SECONDS);
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid() {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        authStrategy.authenticate(user, "wrong");
        authStrategy.authenticate(user, "wrong");
        authStrategy.authenticate(user, "wrong");
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS));
        clock.forward(5L, TimeUnit.SECONDS);
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldAllowUnlimitedFailedAttemptsWhenMaxFailedAttemptsIsZero() {
        this.testUnlimitedFailedAuthAttempts(0);
    }

    @Test
    public void shouldAllowUnlimitedFailedAttemptsWhenMaxFailedAttemptsIsNegative() {
        this.testUnlimitedFailedAuthAttempts(-42);
    }

    private void testUnlimitedFailedAuthAttempts(int maxFailedAttempts) {
        FakeClock clock = this.getFakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, maxFailedAttempts);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        int attempts = ThreadLocalRandom.current().nextInt(5, 100);
        for (int i = 0; i < attempts; ++i) {
            Assert.assertEquals((Object)AuthenticationResult.FAILURE, (Object)authStrategy.authenticate(user, "wrong"));
        }
    }

    private FakeClock getFakeClock() {
        return Clocks.fakeClock();
    }
}

