/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.commandline.admin.security.SetDefaultAdminCommand;
import org.neo4j.commandline.admin.security.SetDefaultAdminCommandProvider;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.test.rule.TestDirectory;

public class SetDefaultAdminCommandTest {
    private SetDefaultAdminCommand setDefaultAdmin;
    private File adminIniFile;
    private FileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    private Config config;
    @Rule
    public ExpectedException expect = ExpectedException.none();
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory((FileSystemAbstraction)this.fileSystem);

    @Before
    public void setup() throws IOException, InvalidArgumentsException {
        OutsideWorld mock = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        Mockito.when((Object)mock.fileSystem()).thenReturn((Object)this.fileSystem);
        this.setDefaultAdmin = new SetDefaultAdminCommand(this.testDir.directory("home").toPath(), this.testDir.directory("conf").toPath(), mock);
        this.config = this.setDefaultAdmin.loadNeo4jConfig();
        FileUserRepository users = CommunitySecurityModule.getUserRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fileSystem);
        users.create(new User.Builder("jake", Credential.forPassword((String)"123")).withRequiredPasswordChange(false).build());
        this.adminIniFile = new File(CommunitySecurityModule.getUserRepositoryFile((Config)this.config).getParentFile(), "admin.ini");
    }

    @Test
    public void shouldFailForNoArguments() throws Exception {
        org.neo4j.test.assertion.Assert.assertException(() -> this.setDefaultAdmin.execute(new String[0]), IncorrectUsage.class, (String)"not enough arguments");
    }

    @Test
    public void shouldFailForTooManyArguments() throws Exception {
        String[] arguments = new String[]{"", "123", "321"};
        org.neo4j.test.assertion.Assert.assertException(() -> this.setDefaultAdmin.execute(arguments), IncorrectUsage.class, (String)"unrecognized arguments: '123 321'");
    }

    @Test
    public void shouldSetDefaultAdmin() throws Throwable {
        Assert.assertFalse((boolean)this.fileSystem.fileExists(this.adminIniFile));
        String[] arguments = new String[]{"jake"};
        this.setDefaultAdmin.execute(arguments);
        this.assertAdminIniFile("jake");
    }

    @Test
    public void shouldNotSetDefaultAdminForNonExistentUser() throws Throwable {
        this.expect.expect(CommandFailed.class);
        this.expect.expectMessage("no such user: 'noName'");
        String[] arguments = new String[]{"noName"};
        this.setDefaultAdmin.execute(arguments);
    }

    @Test
    public void shouldPrintNiceHelp() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new SetDefaultAdminCommandProvider(), ps::println);
            Assert.assertEquals((Object)String.format("usage: neo4j-admin set-default-admin <username>%n%nenvironment variables:%n    NEO4J_CONF    Path to directory which contains neo4j.conf.%n    NEO4J_DEBUG   Set to anything to enable debug output.%n    NEO4J_HOME    Neo4j home directory.%n    HEAP_SIZE     Set JVM maximum heap size during command execution.%n                  Takes a number and a unit, for example 512m.%n%nSets the user to become admin if users but no roles are present, for example%nwhen upgrading to neo4j 3.1 enterprise.%n", new Object[0]), (Object)baos.toString());
        }
    }

    private void assertAdminIniFile(String username) throws Throwable {
        Assert.assertTrue((boolean)this.fileSystem.fileExists(this.adminIniFile));
        FileUserRepository userRepository = new FileUserRepository(this.fileSystem, this.adminIniFile, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        MatcherAssert.assertThat((Object)userRepository.getAllUsernames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{username}));
    }
}

