/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.test.TestGraphDatabaseBuilder;

public class AuthProceduresTest
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldFailWhenDeprecatedChangePasswordWithStaticAccessModeInDbmsMode() throws Throwable {
        Object[] inputArray = new Object[]{"newPassword"};
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Anonymous cannot change password");
        this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "changePassword"}), inputArray, (SecurityContext)AnonymousContext.none());
    }

    @Test
    public void shouldFailWhenChangePasswordWithStaticAccessModeInDbmsMode() throws Throwable {
        Object[] inputArray = new Object[]{"newPassword"};
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Anonymous cannot change password");
        this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "security", "changePassword"}), inputArray, (SecurityContext)AnonymousContext.none());
    }

    protected TestGraphDatabaseBuilder configure(TestGraphDatabaseBuilder graphDatabaseBuilder) {
        graphDatabaseBuilder.setConfig(GraphDatabaseSettings.auth_enabled, "true");
        return graphDatabaseBuilder;
    }
}

