/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public abstract class InitialUserTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    protected Config config;
    protected UserRepository users;

    protected abstract AuthManager authManager();

    @Test
    public void shouldCreateDefaultUserIfNoneExist() throws Throwable {
        this.authManager().start();
        User user = this.users.getUserByName("neo4j");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.credentials().matchesPassword("neo4j"));
        Assert.assertTrue((boolean)user.passwordChangeRequired());
    }

    @Test
    public void shouldLoadInitialUserIfNoneExist() throws Throwable {
        FileUserRepository initialUserRepository = CommunitySecurityModule.getInitialUserRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fsRule.get());
        initialUserRepository.start();
        initialUserRepository.create(new User.Builder("neo4j", Credential.forPassword((String)"123")).withRequiredPasswordChange(false).build());
        initialUserRepository.shutdown();
        this.authManager().start();
        User user = this.users.getUserByName("neo4j");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.credentials().matchesPassword("123"));
        Assert.assertFalse((boolean)user.passwordChangeRequired());
    }

    @Test
    public void shouldLoadInitialUserIfNoneExistEvenWithSamePassword() throws Throwable {
        FileUserRepository initialUserRepository = CommunitySecurityModule.getInitialUserRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fsRule.get());
        initialUserRepository.start();
        initialUserRepository.create(new User.Builder("neo4j", Credential.forPassword((String)"neo4j")).withRequiredPasswordChange(false).build());
        initialUserRepository.shutdown();
        this.authManager().start();
        User user = this.users.getUserByName("neo4j");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.credentials().matchesPassword("neo4j"));
        Assert.assertFalse((boolean)user.passwordChangeRequired());
    }

    @Test
    public void shouldNotAddInitialUserIfUsersExist() throws Throwable {
        FileUserRepository initialUserRepository = CommunitySecurityModule.getInitialUserRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fsRule.get());
        initialUserRepository.start();
        initialUserRepository.create(this.newUser("initUser", "123", false));
        initialUserRepository.shutdown();
        this.users.start();
        this.users.create(this.newUser("oldUser", "321", false));
        this.users.shutdown();
        this.authManager().start();
        User initUser = this.users.getUserByName("initUser");
        Assert.assertNull((Object)initUser);
        User oldUser = this.users.getUserByName("oldUser");
        Assert.assertNotNull((Object)oldUser);
        Assert.assertTrue((boolean)oldUser.credentials().matchesPassword("321"));
        Assert.assertFalse((boolean)oldUser.passwordChangeRequired());
    }

    @Test
    public void shouldNotUpdateUserIfInitialUserExist() throws Throwable {
        FileUserRepository initialUserRepository = CommunitySecurityModule.getInitialUserRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fsRule.get());
        initialUserRepository.start();
        initialUserRepository.create(this.newUser("oldUser", "newPassword", false));
        initialUserRepository.shutdown();
        this.users.start();
        this.users.create(this.newUser("oldUser", "oldPassword", true));
        this.users.shutdown();
        this.authManager().start();
        User oldUser = this.users.getUserByName("oldUser");
        Assert.assertNotNull((Object)oldUser);
        Assert.assertTrue((boolean)oldUser.credentials().matchesPassword("oldPassword"));
        Assert.assertTrue((boolean)oldUser.passwordChangeRequired());
    }

    protected User newUser(String userName, String password, boolean pwdChange) {
        return new User.Builder(userName, Credential.forPassword((String)password)).withRequiredPasswordChange(pwdChange).build();
    }
}

