/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.BasicSecurityContext;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.InitialUserTest;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.UserRepository;

public class BasicAuthManagerTest
extends InitialUserTest {
    private BasicAuthManager manager;
    private AuthenticationStrategy authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);

    @Before
    public void setup() throws Throwable {
        this.config = Config.defaults();
        this.users = CommunitySecurityModule.getUserRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fsRule.get());
        FileUserRepository initUserRepository = CommunitySecurityModule.getInitialUserRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fsRule.get());
        this.manager = new BasicAuthManager(this.users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), this.authStrategy, (UserRepository)initUserRepository);
        this.manager.init();
    }

    @After
    public void teardown() throws Throwable {
        this.manager.stop();
    }

    @Test
    public void shouldFindAndAuthenticateUserSuccessfully() throws Throwable {
        this.manager.start();
        User user1 = this.newUser("jake", "abc123", false);
        this.users.create(user1);
        User user = user1;
        Mockito.when((Object)this.authStrategy.authenticate(user, "abc123")).thenReturn((Object)AuthenticationResult.SUCCESS);
        this.assertLoginGivesResult("jake", "abc123", AuthenticationResult.SUCCESS);
    }

    @Test
    public void shouldFindAndAuthenticateUserAndReturnAuthStrategyResult() throws Throwable {
        this.manager.start();
        User user1 = this.newUser("jake", "abc123", true);
        this.users.create(user1);
        User user = user1;
        Mockito.when((Object)this.authStrategy.authenticate(user, "abc123")).thenReturn((Object)AuthenticationResult.TOO_MANY_ATTEMPTS);
        this.assertLoginGivesResult("jake", "abc123", AuthenticationResult.TOO_MANY_ATTEMPTS);
    }

    @Test
    public void shouldFindAndAuthenticateUserAndReturnPasswordChangeIfRequired() throws Throwable {
        this.manager.start();
        User user1 = this.newUser("jake", "abc123", true);
        this.users.create(user1);
        User user = user1;
        Mockito.when((Object)this.authStrategy.authenticate(user, "abc123")).thenReturn((Object)AuthenticationResult.SUCCESS);
        this.assertLoginGivesResult("jake", "abc123", AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
    }

    @Test
    public void shouldFailAuthenticationIfUserIsNotFound() throws Throwable {
        this.manager.start();
        User user = this.newUser("jake", "abc123", true);
        this.users.create(user);
        this.assertLoginGivesResult("unknown", "abc123", AuthenticationResult.FAILURE);
    }

    @Test
    public void shouldCreateUser() throws Throwable {
        this.manager.start();
        this.manager.newUser("foo", "bar", true);
        User user = this.users.getUserByName("foo");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.passwordChangeRequired());
        Assert.assertTrue((boolean)user.credentials().matchesPassword("bar"));
    }

    @Test
    public void shouldDeleteUser() throws Throwable {
        this.manager.start();
        this.manager.newUser("jake", "abc123", true);
        this.manager.deleteUser("jake");
        Assert.assertNull((Object)this.users.getUserByName("jake"));
    }

    @Test
    public void shouldFailToDeleteUnknownUser() throws Throwable {
        this.manager.start();
        this.manager.newUser("jake", "abc123", true);
        try {
            this.manager.deleteUser("nonExistentUser");
            TestCase.fail((String)"User 'nonExistentUser' should no longer exist, expected exception.");
        }
        catch (InvalidArgumentsException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"User 'nonExistentUser' does not exist."));
        }
        catch (Throwable t) {
            Assert.assertThat(t.getClass(), (Matcher)IsEqual.equalTo(InvalidArgumentsException.class));
        }
        Assert.assertNotNull((Object)this.users.getUserByName("jake"));
    }

    @Test
    public void shouldSetPassword() throws Throwable {
        this.manager.start();
        this.manager.newUser("jake", "abc123", true);
        this.manager.setUserPassword("jake", "hello, world!", false);
        User user = this.manager.getUser("jake");
        Assert.assertTrue((boolean)user.credentials().matchesPassword("hello, world!"));
        Assert.assertThat((Object)this.users.getUserByName("jake"), (Matcher)Matchers.equalTo((Object)user));
    }

    @Test
    public void shouldReturnNullWhenSettingPasswordForUnknownUser() throws Throwable {
        this.manager.start();
        try {
            this.manager.setUserPassword("unknown", "hello, world!", false);
            Assert.fail((String)"exception expected");
        }
        catch (InvalidArgumentsException invalidArgumentsException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailWhenAuthTokenIsInvalid() throws Throwable {
        this.manager.start();
        org.neo4j.test.assertion.Assert.assertException(() -> this.manager.login(MapUtil.map((Object[])new Object[]{"scheme", "supercool", "principal", "neo4j"})), InvalidAuthTokenException.class, (String)"Unsupported authentication token, scheme 'supercool' is not supported.");
        org.neo4j.test.assertion.Assert.assertException(() -> this.manager.login(MapUtil.map((Object[])new Object[]{"scheme", "none"})), InvalidAuthTokenException.class, (String)"Unsupported authentication token, scheme 'none' is only allowed when auth is disabled");
        org.neo4j.test.assertion.Assert.assertException(() -> this.manager.login(MapUtil.map((Object[])new Object[]{"key", "value"})), InvalidAuthTokenException.class, (String)"Unsupported authentication token, missing key `scheme`");
        org.neo4j.test.assertion.Assert.assertException(() -> this.manager.login(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j"})), InvalidAuthTokenException.class, (String)"Unsupported authentication token, missing key `credentials`");
        org.neo4j.test.assertion.Assert.assertException(() -> this.manager.login(MapUtil.map((Object[])new Object[]{"scheme", "basic", "credentials", "very-secret"})), InvalidAuthTokenException.class, (String)"Unsupported authentication token, missing key `principal`");
    }

    private void assertLoginGivesResult(String username, String password, AuthenticationResult expectedResult) throws InvalidAuthTokenException {
        BasicSecurityContext securityContext = this.manager.login(SecurityTestUtils.authToken(username, password));
        Assert.assertThat((Object)securityContext.subject().getAuthenticationResult(), (Matcher)Matchers.equalTo((Object)expectedResult));
    }

    @Override
    protected AuthManager authManager() {
        return this.manager;
    }
}

