/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.configuration.ConfigLoader;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;

public class SetInitialPasswordCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withMandatoryPositionalArgument(0, "password");
    private final Path homeDir;
    private final Path configDir;
    private OutsideWorld outsideWorld;

    SetInitialPasswordCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    public static Arguments arguments() {
        return arguments;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        try {
            this.setPassword(arguments.parse(args).get(0));
        }
        catch (CommandFailed | IncorrectUsage e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CommandFailed(throwable.getMessage(), (Throwable)new RuntimeException(throwable));
        }
    }

    private void setPassword(String password) throws Throwable {
        Config config = this.loadNeo4jConfig();
        if (this.realUsersExist(config)) {
            throw new CommandFailed("initial password was not set because live Neo4j-users were detected.");
        }
        File file = CommunitySecurityModule.getInitialUserRepositoryFile(config);
        FileSystemAbstraction fileSystem = this.outsideWorld.fileSystem();
        if (fileSystem.fileExists(file)) {
            fileSystem.deleteFile(file);
        }
        FileUserRepository userRepository = new FileUserRepository(fileSystem, file, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        userRepository.create(new User.Builder("neo4j", Credential.forPassword((String)password)).withRequiredPasswordChange(false).build());
        userRepository.shutdown();
        this.outsideWorld.stdOutLine("Changed password for user 'neo4j'.");
    }

    private boolean realUsersExist(Config config) {
        File authFile = CommunitySecurityModule.getUserRepositoryFile(config);
        return this.outsideWorld.fileSystem().fileExists(authFile);
    }

    Config loadNeo4jConfig() {
        return ConfigLoader.loadConfigWithConnectorsDisabled(Optional.of(this.homeDir.toFile()), Optional.of(this.configDir.resolve("neo4j.conf").toFile()), (Pair[])new Pair[0]);
    }
}

