/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.commandline.admin.AdminTool;
import org.neo4j.commandline.admin.BlockerLocator;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.FileUserRepository;

public class SetInitialPasswordCommandIT {
    private FileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    private File confDir;
    private File homeDir;
    private OutsideWorld out;
    private AdminTool tool;
    private static final String SET_PASSWORD = "set-initial-password";

    @Before
    public void setup() {
        File graphDir = new File("graph-db");
        this.confDir = new File(graphDir, "conf");
        this.homeDir = new File(graphDir, "home");
        this.out = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        this.resetOutsideWorldMock();
        this.tool = new AdminTool(CommandLocator.fromServiceLocator(), BlockerLocator.fromServiceLocator(), this.out, true);
    }

    @After
    public void tearDown() throws Exception {
        this.fileSystem.close();
    }

    @Test
    public void shouldSetPassword() throws Throwable {
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_PASSWORD, "abc"});
        this.assertAuthIniFile("abc");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdOutLine("Changed password for user 'neo4j'.");
    }

    @Test
    public void shouldOverwriteIfSetPasswordAgain() throws Throwable {
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_PASSWORD, "abc"});
        this.assertAuthIniFile("abc");
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_PASSWORD, "muchBetter"});
        this.assertAuthIniFile("muchBetter");
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)2))).stdOutLine("Changed password for user 'neo4j'.");
    }

    @Test
    public void shouldWorkWithSamePassword() throws Throwable {
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_PASSWORD, "neo4j"});
        this.assertAuthIniFile("neo4j");
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_PASSWORD, "neo4j"});
        this.assertAuthIniFile("neo4j");
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)2))).stdOutLine("Changed password for user 'neo4j'.");
    }

    @Test
    public void shouldGetUsageOnWrongArguments1() throws Throwable {
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_PASSWORD});
        this.assertNoAuthIniFile();
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("No password specified.");
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)2))).stdErrLine("");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("usage: neo4j-admin set-initial-password <password>");
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)2))).stdErrLine("");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("Sets the initial password of the initial admin user ('neo4j').");
        ((OutsideWorld)Mockito.verify((Object)this.out)).exit(1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.out});
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)0))).stdOutLine(Matchers.anyString());
    }

    @Test
    public void shouldGetUsageOnWrongArguments2() throws Throwable {
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_PASSWORD, "foo", "bar"});
        this.assertNoAuthIniFile();
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("Too many arguments.");
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)2))).stdErrLine("");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("usage: neo4j-admin set-initial-password <password>");
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)2))).stdErrLine("");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("Sets the initial password of the initial admin user ('neo4j').");
        ((OutsideWorld)Mockito.verify((Object)this.out)).exit(1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.out});
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)0))).stdOutLine(Matchers.anyString());
    }

    @Test
    public void shouldErrorIfRealUsersAlreadyExist() throws Throwable {
        File authFile = this.getAuthFile("auth");
        this.fileSystem.mkdirs(authFile.getParentFile());
        this.fileSystem.create(authFile);
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_PASSWORD, "will-be-ignored"});
        this.assertNoAuthIniFile();
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)1))).stdErrLine("command failed: initial password was not set because live Neo4j-users were detected.");
        ((OutsideWorld)Mockito.verify((Object)this.out)).exit(1);
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)0))).stdOutLine(Matchers.anyString());
    }

    private void assertAuthIniFile(String password) throws Throwable {
        File authIniFile = this.getAuthFile("auth.ini");
        Assert.assertTrue((boolean)this.fileSystem.fileExists(authIniFile));
        FileUserRepository userRepository = new FileUserRepository(this.fileSystem, authIniFile, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        User neo4j = userRepository.getUserByName("neo4j");
        Assert.assertNotNull((Object)neo4j);
        Assert.assertTrue((boolean)neo4j.credentials().matchesPassword(password));
        Assert.assertFalse((boolean)neo4j.hasFlag("password_change_required"));
    }

    private void assertNoAuthIniFile() {
        Assert.assertFalse((boolean)this.fileSystem.fileExists(this.getAuthFile("auth.ini")));
    }

    private File getAuthFile(String name) {
        return new File(new File(new File(this.homeDir, "data"), "dbms"), name);
    }

    private void resetOutsideWorldMock() {
        Mockito.reset((Object[])new OutsideWorld[]{this.out});
        Mockito.when((Object)this.out.fileSystem()).thenReturn((Object)this.fileSystem);
    }
}

