/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.commandline.admin.AdminTool;
import org.neo4j.commandline.admin.BlockerLocator;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.FileUserRepository;

public class SetDefaultAdminCommandIT {
    private FileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    private File confDir;
    private File homeDir;
    private OutsideWorld out;
    private AdminTool tool;
    private static final String SET_ADMIN = "set-default-admin";

    @Before
    public void setup() {
        File graphDir = new File("graph-db");
        this.confDir = new File(graphDir, "conf");
        this.homeDir = new File(graphDir, "home");
        this.out = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        this.resetOutsideWorldMock();
        this.tool = new AdminTool(CommandLocator.fromServiceLocator(), BlockerLocator.fromServiceLocator(), this.out, true);
    }

    @Test
    public void shouldSetDefaultAdmin() throws Throwable {
        this.insertUser("jane", false);
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_ADMIN, "jane"});
        this.assertAdminIniFile("jane");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdOutLine("default admin user set to 'jane'");
    }

    @Test
    public void shouldSetDefaultAdminForInitialUser() throws Throwable {
        this.insertUser("jane", true);
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_ADMIN, "jane"});
        this.assertAdminIniFile("jane");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdOutLine("default admin user set to 'jane'");
    }

    @Test
    public void shouldOverwrite() throws Throwable {
        this.insertUser("jane", false);
        this.insertUser("janette", false);
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_ADMIN, "jane"});
        this.assertAdminIniFile("jane");
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_ADMIN, "janette"});
        this.assertAdminIniFile("janette");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdOutLine("default admin user set to 'jane'");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdOutLine("default admin user set to 'janette'");
    }

    @Test
    public void shouldErrorWithNoSuchUser() throws Throwable {
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_ADMIN, "bob"});
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("command failed: no such user: 'bob'");
        ((OutsideWorld)Mockito.verify((Object)this.out)).exit(1);
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)0))).stdOutLine(org.mockito.Matchers.anyString());
    }

    @Test
    public void shouldIgnoreInitialUserIfUsersExist() throws Throwable {
        this.insertUser("jane", false);
        this.insertUser("janette", true);
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_ADMIN, "jane"});
        this.assertAdminIniFile("jane");
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_ADMIN, "janette"});
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdOutLine("default admin user set to 'jane'");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("command failed: no such user: 'janette'");
        ((OutsideWorld)Mockito.verify((Object)this.out)).exit(1);
    }

    @Test
    public void shouldGetUsageOnWrongArguments1() throws Throwable {
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_ADMIN});
        this.assertNoAuthIniFile();
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("no username specified.");
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)2))).stdErrLine("");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("usage: neo4j-admin set-default-admin <username>");
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)2))).stdErrLine("");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine(String.format("Sets the user to become admin if users but no roles are present, for example%nwhen upgrading to neo4j 3.1 enterprise.", new Object[0]));
        ((OutsideWorld)Mockito.verify((Object)this.out)).exit(1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.out});
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)0))).stdOutLine(org.mockito.Matchers.anyString());
    }

    @Test
    public void shouldGetUsageOnWrongArguments2() throws Throwable {
        this.tool.execute(this.homeDir.toPath(), this.confDir.toPath(), new String[]{SET_ADMIN, "foo", "bar"});
        this.assertNoAuthIniFile();
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("too many arguments.");
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)2))).stdErrLine("");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine("usage: neo4j-admin set-default-admin <username>");
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)2))).stdErrLine("");
        ((OutsideWorld)Mockito.verify((Object)this.out)).stdErrLine(String.format("Sets the user to become admin if users but no roles are present, for example%nwhen upgrading to neo4j 3.1 enterprise.", new Object[0]));
        ((OutsideWorld)Mockito.verify((Object)this.out)).exit(1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.out});
        ((OutsideWorld)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)0))).stdOutLine(org.mockito.Matchers.anyString());
    }

    private void insertUser(String username, boolean initial) throws Throwable {
        File userFile = this.getAuthFile(initial ? "auth.ini" : "auth");
        FileUserRepository userRepository = new FileUserRepository(this.fileSystem, userFile, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        userRepository.create(new User.Builder(username, Credential.INACCESSIBLE).build());
        Assert.assertTrue((boolean)userRepository.getAllUsernames().contains(username));
        userRepository.stop();
        userRepository.shutdown();
    }

    private void assertAdminIniFile(String username) throws Throwable {
        File adminIniFile = this.getAuthFile("admin.ini");
        Assert.assertTrue((boolean)this.fileSystem.fileExists(adminIniFile));
        FileUserRepository userRepository = new FileUserRepository(this.fileSystem, adminIniFile, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        MatcherAssert.assertThat((Object)userRepository.getAllUsernames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{username}));
        userRepository.stop();
        userRepository.shutdown();
    }

    private void assertNoAuthIniFile() {
        Assert.assertFalse((boolean)this.fileSystem.fileExists(this.getAuthFile("admin.ini")));
    }

    private File getAuthFile(String name) {
        return new File(new File(new File(this.homeDir, "data"), "dbms"), name);
    }

    private void resetOutsideWorldMock() {
        Mockito.reset((Object[])new OutsideWorld[]{this.out});
        Mockito.when((Object)this.out.fileSystem()).thenReturn((Object)this.fileSystem);
    }
}

