/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;

public abstract class AbstractUserRepository
extends LifecycleAdapter
implements UserRepository {
    private final Map<String, User> usersByName = new ConcurrentHashMap<String, User>();
    protected volatile List<User> users = new ArrayList<User>();
    protected AtomicLong lastLoaded = new AtomicLong(0L);
    private final Pattern usernamePattern = Pattern.compile("^[\\x21-\\x2B\\x2D-\\x39\\x3B-\\x7E]+$");

    @Override
    public void clear() {
        this.users.clear();
        this.usersByName.clear();
    }

    @Override
    public User getUserByName(String username) {
        return username == null ? null : this.usersByName.get(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(User user) throws InvalidArgumentsException, IOException {
        this.assertValidUsername(user.name());
        AbstractUserRepository abstractUserRepository = this;
        synchronized (abstractUserRepository) {
            for (User other : this.users) {
                if (!other.name().equals(user.name())) continue;
                throw new InvalidArgumentsException("The specified user '" + user.name() + "' already exists.");
            }
            this.users.add(user);
            this.usersByName.put(user.name(), user);
            this.persistUsers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsers(ListSnapshot<User> usersSnapshot) throws InvalidArgumentsException, IOException {
        for (User user : usersSnapshot.values()) {
            this.assertValidUsername(user.name());
        }
        AbstractUserRepository abstractUserRepository = this;
        synchronized (abstractUserRepository) {
            this.users.clear();
            this.users.addAll(usersSnapshot.values());
            this.lastLoaded.set(usersSnapshot.timestamp());
            MapUtil.trimToList(this.usersByName, this.users, User::name);
            for (User user : this.users) {
                this.usersByName.put(user.name(), user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(User existingUser, User updatedUser) throws ConcurrentModificationException, IOException, InvalidArgumentsException {
        if (!existingUser.name().equals(updatedUser.name())) {
            throw new IllegalArgumentException("The attempt to update the role from '" + existingUser.name() + "' to '" + updatedUser.name() + "' failed. Changing a roles name is not allowed.");
        }
        AbstractUserRepository abstractUserRepository = this;
        synchronized (abstractUserRepository) {
            ArrayList<User> newUsers = new ArrayList<User>();
            boolean foundUser = false;
            for (User other : this.users) {
                if (other.equals(existingUser)) {
                    foundUser = true;
                    newUsers.add(updatedUser);
                    continue;
                }
                newUsers.add(other);
            }
            if (!foundUser) {
                throw new ConcurrentModificationException();
            }
            this.users = newUsers;
            this.usersByName.put(updatedUser.name(), updatedUser);
            this.persistUsers();
        }
    }

    @Override
    public synchronized boolean delete(User user) throws IOException {
        boolean foundUser = false;
        ArrayList<User> newUsers = new ArrayList<User>();
        for (User other : this.users) {
            if (other.name().equals(user.name())) {
                foundUser = true;
                continue;
            }
            newUsers.add(other);
        }
        if (foundUser) {
            this.users = newUsers;
            this.usersByName.remove(user.name());
            this.persistUsers();
        }
        return foundUser;
    }

    @Override
    public synchronized int numberOfUsers() {
        return this.users.size();
    }

    @Override
    public void assertValidUsername(String username) throws InvalidArgumentsException {
        if (username == null || username.isEmpty()) {
            throw new InvalidArgumentsException("The provided username is empty.");
        }
        if (!this.usernamePattern.matcher(username).matches()) {
            throw new InvalidArgumentsException("Username '" + username + "' contains illegal characters. Use ascii characters that are not ',', ':' or whitespaces.");
        }
    }

    @Override
    public synchronized Set<String> getAllUsernames() {
        return this.users.stream().map(User::name).collect(Collectors.toSet());
    }

    protected abstract void persistUsers() throws IOException;

    protected abstract ListSnapshot<User> readPersistedUsers() throws IOException;
}

