/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.security.auth.Credential;

public class CredentialTest {
    @Test
    public void testMatchesPassword() {
        Credential credential = Credential.forPassword((String)"foo");
        Assert.assertTrue((boolean)credential.matchesPassword("foo"));
        Assert.assertFalse((boolean)credential.matchesPassword("fooo"));
        Assert.assertFalse((boolean)credential.matchesPassword("fo"));
        Assert.assertFalse((boolean)credential.matchesPassword("bar"));
    }

    @Test
    public void testEquals() {
        Credential credential = Credential.forPassword((String)"foo");
        Credential sameCredential = new Credential(credential.salt(), credential.passwordHash());
        Assert.assertTrue((boolean)credential.equals((Object)sameCredential));
    }

    @Test
    public void testInaccessibleCredentials() {
        Credential credential = new Credential(Credential.INACCESSIBLE.salt(), Credential.INACCESSIBLE.passwordHash());
        Assert.assertTrue((boolean)Credential.INACCESSIBLE.equals((Object)credential));
        Assert.assertTrue((boolean)credential.equals((Object)Credential.INACCESSIBLE));
        Assert.assertTrue((boolean)Credential.INACCESSIBLE.equals((Object)Credential.INACCESSIBLE));
        Assert.assertFalse((boolean)Credential.INACCESSIBLE.equals((Object)Credential.forPassword((String)"")));
        Assert.assertFalse((boolean)Credential.forPassword((String)"").equals((Object)Credential.INACCESSIBLE));
        Assert.assertFalse((boolean)Credential.INACCESSIBLE.matchesPassword(new String(new byte[0])));
        Assert.assertFalse((boolean)Credential.INACCESSIBLE.matchesPassword("foo"));
        Assert.assertFalse((boolean)Credential.INACCESSIBLE.matchesPassword(""));
    }
}

