/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.User;

public class UserTest {
    @Test
    public void shouldBuildImmutableUser() {
        Credential abc = Credential.forPassword((String)"123abc");
        Credential fruit = Credential.forPassword((String)"fruit");
        User u1 = new User.Builder("Steve", abc).build();
        User u2 = new User.Builder("Steve", fruit).withRequiredPasswordChange(true).withFlag("nice_guy").build();
        MatcherAssert.assertThat((Object)u1, (Matcher)CoreMatchers.equalTo((Object)u1));
        MatcherAssert.assertThat((Object)u1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)u2)));
        User u1_as_u2 = u1.augment().withCredentials(fruit).withRequiredPasswordChange(true).withFlag("nice_guy").build();
        MatcherAssert.assertThat((Object)u1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)u1_as_u2)));
        MatcherAssert.assertThat((Object)u2, (Matcher)CoreMatchers.equalTo((Object)u1_as_u2));
        User u2_as_u1 = u2.augment().withCredentials(abc).withRequiredPasswordChange(false).withoutFlag("nice_guy").build();
        MatcherAssert.assertThat((Object)u2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)u2_as_u1)));
        MatcherAssert.assertThat((Object)u1, (Matcher)CoreMatchers.equalTo((Object)u2_as_u1));
        MatcherAssert.assertThat((Object)u1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)u2)));
    }
}

