/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.commandline.admin.security.SetInitialPasswordCommand;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.User;
import org.neo4j.test.rule.TestDirectory;

public class SetInitialPasswordCommandTest {
    private SetInitialPasswordCommand setPasswordCommand;
    private File authInitFile;
    private File authFile;
    private FileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory((FileSystemAbstraction)this.fileSystem);

    @Before
    public void setup() {
        OutsideWorld mock = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        Mockito.when((Object)mock.fileSystem()).thenReturn((Object)this.fileSystem);
        this.setPasswordCommand = new SetInitialPasswordCommand(this.testDir.directory("home").toPath(), this.testDir.directory("conf").toPath(), mock);
        this.authInitFile = CommunitySecurityModule.getInitialUserRepositoryFile((Config)this.setPasswordCommand.loadNeo4jConfig());
        this.authFile = CommunitySecurityModule.getUserRepositoryFile((Config)this.setPasswordCommand.loadNeo4jConfig());
    }

    @Test
    public void shouldFailSetPasswordWithNoArguments() throws Exception {
        org.neo4j.test.assertion.Assert.assertException(() -> this.setPasswordCommand.execute(new String[0]), IncorrectUsage.class, (String)"No password specified.");
    }

    @Test
    public void shouldFailSetPasswordWithTooManyArguments() throws Exception {
        String[] arguments = new String[]{"", "123", "321"};
        org.neo4j.test.assertion.Assert.assertException(() -> this.setPasswordCommand.execute(arguments), IncorrectUsage.class, (String)"Too many arguments.");
    }

    @Test
    public void shouldSetInitialPassword() throws Throwable {
        Assert.assertFalse((boolean)this.fileSystem.fileExists(this.authInitFile));
        String[] arguments = new String[]{"123"};
        this.setPasswordCommand.execute(arguments);
        this.assertAuthIniFile("123");
    }

    @Test
    public void shouldOverwriteInitialPasswordFileIfExists() throws Throwable {
        this.fileSystem.mkdirs(this.authInitFile.getParentFile());
        this.fileSystem.create(this.authInitFile);
        String[] arguments = new String[]{"123"};
        this.setPasswordCommand.execute(arguments);
        this.assertAuthIniFile("123");
    }

    @Test
    public void shouldWorkAlsoWithSamePassword() throws Throwable {
        String[] arguments = new String[]{"neo4j"};
        this.setPasswordCommand.execute(arguments);
        this.assertAuthIniFile("neo4j");
    }

    @Test
    public void shouldPrintNiceHelp() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new SetInitialPasswordCommand.Provider(), ps::println);
            Assert.assertEquals((Object)String.format("usage: neo4j-admin set-initial-password <password>%n%nSets the initial password of the initial admin user ('neo4j').%n", new Object[0]), (Object)baos.toString());
        }
    }

    private void assertAuthIniFile(String password) throws Throwable {
        Assert.assertTrue((boolean)this.fileSystem.fileExists(this.authInitFile));
        FileUserRepository userRepository = new FileUserRepository(this.fileSystem, this.authInitFile, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        User neo4j = userRepository.getUserByName("neo4j");
        Assert.assertNotNull((Object)neo4j);
        Assert.assertTrue((boolean)neo4j.credentials().matchesPassword(password));
        Assert.assertFalse((boolean)neo4j.hasFlag("password_change_required"));
    }
}

