/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.User;
import org.neo4j.string.HexString;
import org.neo4j.string.UTF8;

public class UserSerialization {
    private static final String userSeparator = ":";
    private static final String credentialSeparator = ",";

    public byte[] serialize(Collection<User> users) {
        StringBuilder sb = new StringBuilder();
        for (User user : users) {
            sb.append(this.serialize(user)).append("\n");
        }
        return UTF8.encode((String)sb.toString());
    }

    public List<User> deserializeUsers(byte[] bytes) throws FormatException {
        ArrayList<User> out = new ArrayList<User>();
        int lineNumber = 1;
        for (String line : UTF8.decode((byte[])bytes).split("\n")) {
            if (line.trim().length() > 0) {
                out.add(this.deserializeUser(line, lineNumber));
            }
            ++lineNumber;
        }
        return out;
    }

    private String serialize(User user) {
        return String.join((CharSequence)userSeparator, user.name(), this.serialize(user.credentials()), String.join((CharSequence)credentialSeparator, user.getFlags()));
    }

    private User deserializeUser(String line, int lineNumber) throws FormatException {
        String[] parts = line.split(userSeparator, -1);
        if (parts.length != 3) {
            throw new FormatException(String.format("wrong number of line fields, expected 3, got %d [line %d]", parts.length, lineNumber));
        }
        User.Builder b = new User.Builder().withName(parts[0]).withCredentials(this.deserializeCredentials(parts[1], lineNumber));
        for (String flag : parts[2].split(credentialSeparator, -1)) {
            String trimmed = flag.trim();
            if (trimmed.isEmpty()) continue;
            b = b.withFlag(trimmed);
        }
        return b.build();
    }

    private String serialize(Credential cred) {
        String encodedSalt = HexString.encodeHexString((byte[])cred.salt());
        String encodedPassword = HexString.encodeHexString((byte[])cred.passwordHash());
        return String.join((CharSequence)credentialSeparator, "SHA-256", encodedPassword, encodedSalt);
    }

    private Credential deserializeCredentials(String part, int lineNumber) throws FormatException {
        String[] split = part.split(credentialSeparator, -1);
        if (split.length != 3) {
            throw new FormatException(String.format("wrong number of credential fields [line %d]", lineNumber));
        }
        if (!split[0].equals("SHA-256")) {
            throw new FormatException(String.format("unknown digest \"%s\" [line %d]", split[0], lineNumber));
        }
        byte[] decodedPassword = HexString.decodeHexString((String)split[1]);
        byte[] decodedSalt = HexString.decodeHexString((String)split[2]);
        return new Credential(decodedSalt, decodedPassword);
    }

    public class FormatException
    extends Exception {
        FormatException(String message) {
            super(message);
        }
    }
}

