/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.time.Clock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.User;

public class RateLimitedAuthenticationStrategy
implements AuthenticationStrategy {
    private static final int FAILED_AUTH_COOLDOWN_PERIOD = 5000;
    private final Clock clock;
    private final int maxFailedAttempts;
    private final ConcurrentMap<String, AuthenticationMetadata> authenticationData = new ConcurrentHashMap<String, AuthenticationMetadata>();

    public RateLimitedAuthenticationStrategy(Clock clock, int maxFailedAttempts) {
        this.clock = clock;
        this.maxFailedAttempts = maxFailedAttempts;
    }

    @Override
    public boolean isAuthenticationPermitted(String username) {
        AuthenticationMetadata authMetadata = this.authMetadataFor(username);
        return authMetadata.authenticationPermitted();
    }

    @Override
    public void updateWithAuthenticationResult(AuthenticationResult result, String username) {
        AuthenticationMetadata authMetadata = this.authMetadataFor(username);
        if (result == AuthenticationResult.FAILURE) {
            authMetadata.authFailed();
        } else {
            authMetadata.authSuccess();
        }
    }

    @Override
    public AuthenticationResult authenticate(User user, String password) {
        AuthenticationMetadata authMetadata = this.authMetadataFor(user.name());
        if (!this.isAuthenticationPermitted(user.name())) {
            return AuthenticationResult.TOO_MANY_ATTEMPTS;
        }
        if (user.credentials().matchesPassword(password)) {
            authMetadata.authSuccess();
            return AuthenticationResult.SUCCESS;
        }
        authMetadata.authFailed();
        return AuthenticationResult.FAILURE;
    }

    private AuthenticationMetadata authMetadataFor(String username) {
        AuthenticationMetadata preExisting;
        AuthenticationMetadata authMeta = (AuthenticationMetadata)this.authenticationData.get(username);
        if (authMeta == null && (preExisting = this.authenticationData.putIfAbsent(username, authMeta = new AuthenticationMetadata())) != null) {
            authMeta = preExisting;
        }
        return authMeta;
    }

    private class AuthenticationMetadata {
        private final AtomicInteger failedAuthAttempts = new AtomicInteger();
        private long lastFailedAttemptTime = 0L;

        private AuthenticationMetadata() {
        }

        public boolean authenticationPermitted() {
            return this.failedAuthAttempts.get() < RateLimitedAuthenticationStrategy.this.maxFailedAttempts || RateLimitedAuthenticationStrategy.this.clock.millis() >= this.lastFailedAttemptTime + 5000L;
        }

        public void authSuccess() {
            this.failedAuthAttempts.set(0);
        }

        public void authFailed() {
            this.failedAuthAttempts.incrementAndGet();
            this.lastFailedAttemptTime = RateLimitedAuthenticationStrategy.this.clock.millis();
        }
    }
}

