/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.User;
import org.neo4j.time.FakeClock;

public class RateLimitedAuthenticationStrategyTest {
    @Test
    public void shouldReturnSuccessForValidAttempt() throws Exception {
        FakeClock clock = new FakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldReturnFailureForInvalidAttempt() throws Exception {
        FakeClock clock = new FakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldNotSlowRequestRateOnLessThanMaxFailedAttempts() throws Exception {
        FakeClock clock = new FakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldSlowRequestRateOnMultipleFailedAttempts() throws Exception {
        FakeClock clock = new FakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS));
        clock.forward(5L, TimeUnit.SECONDS);
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldSlowRequestRateOnMultipleFailedAttemptsWhereAttemptIsValid() throws Exception {
        FakeClock clock = new FakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User.Builder("user", Credential.forPassword((String)"right")).build();
        authStrategy.authenticate(user, "wrong");
        authStrategy.authenticate(user, "wrong");
        authStrategy.authenticate(user, "wrong");
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS));
        clock.forward(5L, TimeUnit.SECONDS);
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }
}

