/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.exception.IllegalCredentialsException;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.PasswordPolicy;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;

public class BasicAuthManagerTest {
    @Test
    public void shouldCreateDefaultUserIfNoneExist() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        User user = users.getUserByName("neo4j");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.credentials().matchesPassword("neo4j"));
        Assert.assertTrue((boolean)user.passwordChangeRequired());
    }

    @Test
    public void shouldFindAndAuthenticateUserSuccessfully() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User.Builder("jake", Credential.forPassword((String)"abc123")).build();
        users.create(user);
        AuthenticationStrategy authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), authStrategy);
        manager.start();
        Mockito.when((Object)authStrategy.authenticate(user, "abc123")).thenReturn((Object)AuthenticationResult.SUCCESS);
        AuthSubject authSubject = manager.login(SecurityTestUtils.authToken("jake", "abc123"));
        AuthenticationResult result = authSubject.getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldFindAndAuthenticateUserAndReturnAuthStrategyResult() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User.Builder("jake", Credential.forPassword((String)"abc123")).withRequiredPasswordChange(true).build();
        users.create(user);
        AuthenticationStrategy authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), authStrategy);
        manager.start();
        Mockito.when((Object)authStrategy.authenticate(user, "abc123")).thenReturn((Object)AuthenticationResult.TOO_MANY_ATTEMPTS);
        AuthSubject authSubject = manager.login(SecurityTestUtils.authToken("jake", "abc123"));
        AuthenticationResult result = authSubject.getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS));
    }

    @Test
    public void shouldFindAndAuthenticateUserAndReturnPasswordChangeIfRequired() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User.Builder("jake", Credential.forPassword((String)"abc123")).withRequiredPasswordChange(true).build();
        users.create(user);
        AuthenticationStrategy authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), authStrategy);
        manager.start();
        Mockito.when((Object)authStrategy.authenticate(user, "abc123")).thenReturn((Object)AuthenticationResult.SUCCESS);
        AuthSubject authSubject = manager.login(SecurityTestUtils.authToken("jake", "abc123"));
        AuthenticationResult result = authSubject.getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED));
    }

    @Test
    public void shouldFailAuthenticationIfUserIsNotFound() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User.Builder("jake", Credential.forPassword((String)"abc123")).withRequiredPasswordChange(true).build();
        users.create(user);
        AuthenticationStrategy authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), authStrategy);
        manager.start();
        AuthSubject authSubject = manager.login(SecurityTestUtils.authToken("unknown", "abc123"));
        AuthenticationResult result = authSubject.getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldCreateUser() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        manager.newUser("foo", "bar", true);
        User user = users.getUserByName("foo");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.passwordChangeRequired());
        Assert.assertTrue((boolean)user.credentials().matchesPassword("bar"));
    }

    @Test
    public void shouldDeleteUser() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User.Builder("jake", Credential.forPassword((String)"abc123")).withRequiredPasswordChange(true).build();
        users.create(user);
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        manager.deleteUser("jake");
        Assert.assertNull((Object)users.getUserByName("jake"));
    }

    @Test
    public void shouldDeleteUnknownUser() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User.Builder("jake", Credential.forPassword((String)"abc123")).withRequiredPasswordChange(true).build();
        users.create(user);
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        manager.deleteUser("unknown");
        Assert.assertNotNull((Object)users.getUserByName("jake"));
    }

    @Test
    public void shouldSetPassword() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        users.create(new User.Builder("jake", Credential.forPassword((String)"abc123")).withRequiredPasswordChange(true).build());
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        manager.setUserPassword("jake", "hello, world!");
        User user = manager.getUser("jake");
        Assert.assertTrue((boolean)user.credentials().matchesPassword("hello, world!"));
        Assert.assertThat((Object)users.getUserByName("jake"), (Matcher)Matchers.equalTo((Object)user));
    }

    @Test
    public void shouldReturnNullWhenSettingPasswordForUnknownUser() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        try {
            manager.setUserPassword("unknown", "hello, world!");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalCredentialsException illegalCredentialsException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowWhenAuthIsDisabled() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, (PasswordPolicy)Mockito.mock(PasswordPolicy.class), (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class), false);
        manager.start();
        try {
            manager.login(SecurityTestUtils.authToken("foo", "bar"));
            Assert.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            manager.newUser("foo", "bar", true);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            manager.deleteUser("foo");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            manager.getUser("foo");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            manager.setUserPassword("foo", "bar");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((users.numberOfUsers() == 0 ? 1 : 0) != 0);
    }
}

