/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.time.Clock;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.security.auth.AuthManager;
import org.neo4j.server.security.auth.AuthSubject;
import org.neo4j.server.security.auth.AuthenticationResult;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicAuthSubject;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;
import org.neo4j.server.security.auth.exception.IllegalCredentialsException;

public class BasicAuthManager
extends LifecycleAdapter
implements AuthManager {
    private final AuthenticationStrategy authStrategy;
    private final UserRepository users;
    private final boolean authEnabled;

    public BasicAuthManager(UserRepository users, AuthenticationStrategy authStrategy, boolean authEnabled) {
        this.users = users;
        this.authStrategy = authStrategy;
        this.authEnabled = authEnabled;
    }

    public BasicAuthManager(UserRepository users, AuthenticationStrategy authStrategy) {
        this(users, authStrategy, true);
    }

    public BasicAuthManager(UserRepository users, Clock clock, boolean authEnabled) {
        this(users, new RateLimitedAuthenticationStrategy(clock, 3), authEnabled);
    }

    public void start() throws Throwable {
        if (this.authEnabled && this.users.numberOfUsers() == 0) {
            this.newUser("neo4j", "neo4j", true);
        }
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        AuthSubject subject = this.login(username, password);
        return subject.getAuthenticationResult();
    }

    @Override
    public AuthSubject login(String username, String password) {
        this.assertAuthEnabled();
        User user = this.users.findByName(username);
        AuthenticationResult result = AuthenticationResult.FAILURE;
        if (user != null && (result = this.authStrategy.authenticate(user, password)) == AuthenticationResult.SUCCESS && user.passwordChangeRequired()) {
            result = AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
        }
        return new BasicAuthSubject(this, user, result);
    }

    @Override
    public User newUser(String username, String initialPassword, boolean requirePasswordChange) throws IOException, IllegalCredentialsException {
        this.assertAuthEnabled();
        this.assertValidName(username);
        User user = new User.Builder().withName(username).withCredentials(Credential.forPassword(initialPassword)).withRequiredPasswordChange(requirePasswordChange).build();
        this.users.create(user);
        return user;
    }

    @Override
    public boolean deleteUser(String username) throws IOException {
        this.assertAuthEnabled();
        User user = this.users.findByName(username);
        return user != null && this.users.delete(user);
    }

    @Override
    public User getUser(String username) {
        this.assertAuthEnabled();
        return this.users.findByName(username);
    }

    public void setPassword(AuthSubject authSubject, String username, String password) throws IOException {
        if (!(authSubject instanceof BasicAuthSubject)) {
            throw new IllegalArgumentException("Incorrect AuthSubject type " + authSubject.getClass().getTypeName());
        }
        BasicAuthSubject basicAuthSubject = (BasicAuthSubject)authSubject;
        if (!basicAuthSubject.doesUsernameMatch(username)) {
            throw new AuthorizationViolationException("Invalid attempt to change the password for user " + username);
        }
        if (this.setPassword(username, password) == null) {
            throw new IllegalArgumentException("User " + username + " does not exist");
        }
    }

    @Override
    public User setPassword(String username, String password) throws IOException {
        this.assertAuthEnabled();
        User existingUser = this.users.findByName(username);
        if (existingUser == null) {
            return null;
        }
        if (existingUser.credentials().matchesPassword(password)) {
            return existingUser;
        }
        try {
            User updatedUser = existingUser.augment().withCredentials(Credential.forPassword(password)).withRequiredPasswordChange(false).build();
            this.users.update(existingUser, updatedUser);
            return updatedUser;
        }
        catch (ConcurrentModificationException e) {
            return this.setPassword(username, password);
        }
    }

    private void assertAuthEnabled() {
        if (!this.authEnabled) {
            throw new IllegalStateException("Auth not enabled");
        }
    }

    private void assertValidName(String name) {
        if (!this.users.isValidName(name)) {
            throw new IllegalArgumentException("User name contains illegal characters. Please use simple ascii characters and numbers.");
        }
    }
}

