/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntLongMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIntMap;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongList;
import org.neo4j.collection.primitive.PrimitiveLongLongMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.IntKeyLongValueTable;
import org.neo4j.collection.primitive.hopscotch.IntKeyObjectValueTable;
import org.neo4j.collection.primitive.hopscotch.IntKeyTable;
import org.neo4j.collection.primitive.hopscotch.IntKeyUnsafeTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyIntValueTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyLongValueTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyLongValueUnsafeTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyObjectValueTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyUnsafeTable;
import org.neo4j.collection.primitive.hopscotch.PrimitiveIntHashSet;
import org.neo4j.collection.primitive.hopscotch.PrimitiveIntLongHashMap;
import org.neo4j.collection.primitive.hopscotch.PrimitiveIntObjectHashMap;
import org.neo4j.collection.primitive.hopscotch.PrimitiveLongHashSet;
import org.neo4j.collection.primitive.hopscotch.PrimitiveLongIntHashMap;
import org.neo4j.collection.primitive.hopscotch.PrimitiveLongLongHashMap;
import org.neo4j.collection.primitive.hopscotch.PrimitiveLongObjectHashMap;

public class Primitive {
    public static final Object VALUE_MARKER = new Object();
    public static final int DEFAULT_HEAP_CAPACITY = 16;
    public static final int DEFAULT_OFFHEAP_CAPACITY = 0x100000;

    private Primitive() {
    }

    public static PrimitiveLongList longList() {
        return new PrimitiveLongList();
    }

    public static PrimitiveLongList longList(int size) {
        return new PrimitiveLongList(size);
    }

    public static PrimitiveLongSet longSet() {
        return Primitive.longSet(16);
    }

    public static PrimitiveLongSet longSet(int initialCapacity) {
        return new PrimitiveLongHashSet(new LongKeyTable<Object>(initialCapacity, VALUE_MARKER), VALUE_MARKER, HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static PrimitiveLongSet offHeapLongSet() {
        return Primitive.offHeapLongSet(0x100000);
    }

    public static PrimitiveLongSet offHeapLongSet(int initialCapacity) {
        return new PrimitiveLongHashSet(new LongKeyUnsafeTable<Object>(initialCapacity, VALUE_MARKER), VALUE_MARKER, HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static PrimitiveLongIntMap longIntMap() {
        return Primitive.longIntMap(16);
    }

    public static PrimitiveLongIntMap longIntMap(int initialCapacity) {
        return new PrimitiveLongIntHashMap(new LongKeyIntValueTable(initialCapacity), HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static PrimitiveLongLongMap longLongMap() {
        return Primitive.longLongMap(16);
    }

    public static PrimitiveLongLongMap longLongMap(int initialCapacity) {
        return new PrimitiveLongLongHashMap(new LongKeyLongValueTable(initialCapacity), HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static PrimitiveLongLongMap offHeapLongLongMap() {
        return Primitive.offHeapLongLongMap(0x100000);
    }

    public static PrimitiveLongLongMap offHeapLongLongMap(int initialCapacity) {
        return new PrimitiveLongLongHashMap(new LongKeyLongValueUnsafeTable(initialCapacity), HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static <VALUE> PrimitiveLongObjectMap<VALUE> longObjectMap() {
        return Primitive.longObjectMap(16);
    }

    public static <VALUE> PrimitiveLongObjectMap<VALUE> longObjectMap(int initialCapacity) {
        return new PrimitiveLongObjectHashMap(new LongKeyObjectValueTable(initialCapacity), HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static PrimitiveIntSet intSet() {
        return Primitive.intSet(16);
    }

    public static PrimitiveIntSet intSet(int initialCapacity) {
        return new PrimitiveIntHashSet(new IntKeyTable<Object>(initialCapacity, VALUE_MARKER), VALUE_MARKER, HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static PrimitiveIntSet offHeapIntSet() {
        return new PrimitiveIntHashSet(new IntKeyUnsafeTable<Object>(0x100000, VALUE_MARKER), VALUE_MARKER, HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static PrimitiveIntSet offHeapIntSet(int initialCapacity) {
        return new PrimitiveIntHashSet(new IntKeyUnsafeTable<Object>(initialCapacity, VALUE_MARKER), VALUE_MARKER, HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static <VALUE> PrimitiveIntObjectMap<VALUE> intObjectMap() {
        return Primitive.intObjectMap(16);
    }

    public static <VALUE> PrimitiveIntObjectMap<VALUE> intObjectMap(int initialCapacity) {
        return new PrimitiveIntObjectHashMap(new IntKeyObjectValueTable(initialCapacity), HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static PrimitiveIntLongMap intLongMap() {
        return Primitive.intLongMap(16);
    }

    public static PrimitiveIntLongMap intLongMap(int initialCapacity) {
        return new PrimitiveIntLongHashMap(new IntKeyLongValueTable(initialCapacity), HopScotchHashingAlgorithm.NO_MONITOR);
    }

    public static PrimitiveLongIterator iterator(final long ... longs) {
        return new PrimitiveLongIterator(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < longs.length;
            }

            @Override
            public long next() {
                return longs[this.i++];
            }
        };
    }

    public static PrimitiveIntIterator iterator(final int ... ints) {
        return new PrimitiveIntIterator(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < ints.length;
            }

            @Override
            public int next() {
                return ints[this.i++];
            }
        };
    }
}

