/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveIntVisitor;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.LongKeyTable;
import org.neo4j.collection.primitive.hopscotch.PrimitiveLongHashSet;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveLongSetTest {
    private PrimitiveLongHashSet newSet(int h) {
        return this.newSet(h, HopScotchHashingAlgorithm.NO_MONITOR);
    }

    private PrimitiveLongHashSet newSet(int h, HopScotchHashingAlgorithm.Monitor monitor) {
        return new PrimitiveLongHashSet((Table)new LongKeyTable(h, Primitive.VALUE_MARKER), Primitive.VALUE_MARKER, monitor);
    }

    @Test
    public void shouldContainAddedValues_generated_1() throws Exception {
        long[] valuesToAdd;
        PrimitiveLongHashSet set = this.newSet(15);
        HashSet<Long> expectedValues = new HashSet<Long>();
        for (long key : valuesToAdd = new long[]{1207043189L, 380713862L, 1902858197L, 1996873101L, 1357024628L, 1044248801L, 1558157493L, 2040311008L, 2017660098L, 1332670047L, 663662790L, 2063747422L, 1554358949L, 1761477445L, 1141526838L, 1698679618L, 1279767067L, 508574L, 2071755904L}) {
            set.add(key);
            expectedValues.add(key);
        }
        boolean existedBefore = set.contains(679990875L);
        boolean added = set.add(679990875L);
        boolean existsAfter = set.contains(679990875L);
        Assert.assertFalse((String)"679990875 should not exist before adding here", (boolean)existedBefore);
        Assert.assertTrue((String)"679990875 should be reported as added here", (boolean)added);
        Assert.assertTrue((String)"679990875 should exist", (boolean)existsAfter);
        expectedValues.add(679990875L);
        HashSet visitedKeys = new HashSet();
        set.visitKeys(value -> {
            Assert.assertTrue((boolean)visitedKeys.add(value));
            return false;
        });
        Assert.assertEquals(expectedValues, visitedKeys);
    }

    @Test
    public void shouldContainAddedValues_generated_6() throws Exception {
        PrimitiveLongHashSet set = this.newSet(11);
        set.add(492321488L);
        set.add(877087251L);
        set.add(1809668113L);
        set.add(1766034186L);
        set.add(1879253467L);
        set.add(669295491L);
        set.add(176011165L);
        set.add(1638959981L);
        set.add(1093132636L);
        set.add(6133241L);
        set.add(486112773L);
        set.add(205218385L);
        set.add(1756491867L);
        set.add(90390732L);
        set.add(937266036L);
        set.add(1269020584L);
        set.add(521469166L);
        set.add(1314928747L);
        boolean existedBefore = set.contains(2095121629L);
        boolean added = set.add(2095121629L);
        boolean existsAfter = set.contains(2095121629L);
        Assert.assertFalse((String)"2095121629 should not exist before adding here", (boolean)existedBefore);
        Assert.assertTrue((String)"2095121629 should be reported as added here", (boolean)added);
        Assert.assertTrue((String)"2095121629 should exist", (boolean)existsAfter);
    }

    @Test
    public void shouldContainAddedValues_generated_4() throws Exception {
        PrimitiveLongHashSet set = this.newSet(9);
        set.add(1934106304L);
        set.add(783754072L);
        set.remove(1934106304L);
        boolean existedBefore = set.contains(783754072L);
        boolean added = set.add(783754072L);
        boolean existsAfter = set.contains(783754072L);
        Assert.assertTrue((String)"783754072 should exist before adding here", (boolean)existedBefore);
        Assert.assertFalse((String)"783754072 should not be reported as added here", (boolean)added);
        Assert.assertTrue((String)"783754072 should exist", (boolean)existsAfter);
    }

    @Test
    public void shouldOnlyContainAddedValues_generated_8() throws Exception {
        PrimitiveLongHashSet set = this.newSet(7);
        set.add(375712513L);
        set.remove(1507941820L);
        set.add(671750317L);
        set.remove(1054641019L);
        set.add(671750317L);
        set.add(1768202223L);
        set.add(1768202223L);
        set.add(1927780165L);
        set.add(2139399764L);
        set.remove(1243370828L);
        set.add(1768202223L);
        set.add(1335041891L);
        set.remove(1578984313L);
        set.add(1227954408L);
        set.remove(946917826L);
        set.add(1768202223L);
        set.add(375712513L);
        set.add(1668515054L);
        set.add(401047579L);
        set.add(33226244L);
        set.add(126791689L);
        set.add(401047579L);
        set.add(1963437853L);
        set.add(1739617766L);
        set.add(671750317L);
        set.add(401047579L);
        set.add(789094467L);
        set.add(1291421506L);
        set.add(1694968582L);
        set.add(1508353936L);
        boolean existedBefore = set.contains(1739617766L);
        boolean added = set.add(1739617766L);
        boolean existsAfter = set.contains(1739617766L);
        Assert.assertTrue((String)"1739617766 should exist before adding here", (boolean)existedBefore);
        Assert.assertFalse((String)"1739617766 should not be reported as added here", (boolean)added);
        Assert.assertTrue((String)"1739617766 should exist", (boolean)existsAfter);
    }

    @Test
    public void shouldContainReallyBigLongValue() throws Exception {
        PrimitiveLongHashSet set = this.newSet(10);
        set.add(7416509207113022571L);
        boolean existedBefore = set.contains(7620037383187366331L);
        boolean added = set.add(7620037383187366331L);
        boolean existsAfter = set.contains(7620037383187366331L);
        Assert.assertFalse((String)"7620037383187366331 should not exist before adding here", (boolean)existedBefore);
        Assert.assertTrue((String)"7620037383187366331 should be reported as added here", (boolean)added);
        Assert.assertTrue((String)"7620037383187366331 should exist", (boolean)existsAfter);
    }

    @Test
    public void shouldOnlyContainAddedValues() throws Exception {
        PrimitiveLongHashSet set = this.newSet(13);
        set.add(52450040186687566L);
        set.add(52450040186687566L);
        set.add(5165002753277288833L);
        set.add(4276883133717080762L);
        set.add(5547940863757133161L);
        set.add(8933830774911919116L);
        set.add(3298254474623565974L);
        set.add(3366017425691021883L);
        set.add(8933830774911919116L);
        set.add(2962608069916354604L);
        set.add(3366017425691021883L);
        set.remove(4008464697042048519L);
        set.add(5547940863757133161L);
        set.add(52450040186687566L);
        set.add(4276883133717080762L);
        set.remove(3298254474623565974L);
        set.remove(180852386934131061L);
        set.add(4835176885665539239L);
        set.add(52450040186687566L);
        set.add(4591251124405056753L);
        set.add(5165002753277288833L);
        set.add(8933830774911919116L);
        set.remove(3458250832356869483L);
        set.add(3038543946711308923L);
        set.add(8743060827282266460L);
        set.add(5771902951077476377L);
        set.add(4591251124405056753L);
        set.add(4835176885665539239L);
        set.remove(4827343064671369647L);
        set.add(1533535091190658734L);
        set.remove(7125666881901305989L);
        set.add(1533535091190658734L);
        set.add(52450040186687566L);
        set.remove(1333521853804287175L);
        set.add(2962608069916354604L);
        set.add(5914630622072544054L);
        set.add(52450040186687566L);
        set.add(8933830774911919116L);
        set.add(6198968672674664718L);
        set.add(6239021001199390909L);
        set.add(6563452500080365738L);
        set.add(6128819131542184648L);
        set.add(5914630622072544054L);
        set.add(7024933384543504364L);
        set.remove(3949644814017615281L);
        set.add(3459376060749741528L);
        set.add(3201250389951283395L);
        set.add(4463681497523421181L);
        set.add(4304197328678536531L);
        set.remove(4559066538220393098L);
        set.add(2870119173652414003L);
        set.add(4048902329274369372L);
        set.add(3366017425691021883L);
        set.remove(1092409052848583664L);
        set.add(7024933384543504364L);
        set.add(4276883133717080762L);
        set.add(5914630622072544054L);
        set.add(4048902329274369372L);
        set.add(4304197328678536531L);
        set.add(4151178923662618318L);
        set.remove(51389524801735953L);
        set.add(5371788772386487501L);
        set.remove(8933830774911919116L);
        set.add(4928410670964886834L);
        set.add(8306393274966855450L);
        set.add(2870119173652414003L);
        set.add(8281622709908651825L);
        set.remove(9194058056102544672L);
        set.remove(5547940863757133161L);
        set.add(9184590238993521817L);
        set.add(5085293141623130492L);
        set.add(5633993155928642090L);
        set.remove(8794875254017117580L);
        set.add(5894404415376700909L);
        set.add(4835176885665539239L);
        set.remove(8743060827282266460L);
        set.remove(3460096065015553722L);
        set.remove(3296380689310185627L);
        set.add(337242488691685550L);
        set.add(6239021001199390909L);
        set.add(9104240733803011297L);
        set.add(807326424150812437L);
        set.add(3336115330297894183L);
        set.add(1788796898879121715L);
        set.add(5756965080438171769L);
        set.remove(4366313798399763194L);
        set.add(6198968672674664718L);
        set.add(486897301084183614L);
        set.add(2870119173652414003L);
        set.add(5085293141623130492L);
        set.add(5771902951077476377L);
        set.remove(6563452500080365738L);
        set.add(5347453991851285676L);
        set.add(7437999035528158926L);
        set.add(3223908005448803428L);
        set.add(4300856565210203390L);
        set.remove(4732570527126410147L);
        set.add(2180591071166584277L);
        set.add(5160374384234262648L);
        set.remove(5165002753277288833L);
        set.add(4463681497523421181L);
        set.add(7360196143740041480L);
        set.add(4928410670964886834L);
        set.add(807326424150812437L);
        set.remove(4069279832998820447L);
        set.remove(337242488691685550L);
        set.add(3201250389951283395L);
        set.add(4012293068834101219L);
        set.add(2333643358471038273L);
        set.add(1158824602601458449L);
        set.remove(3906518453155830597L);
        set.add(7402912598585277900L);
        set.add(6556025329057634951L);
        set.add(6684709657047103197L);
        set.remove(3448774195820272496L);
        set.add(715736913341007544L);
        set.add(9104240733803011297L);
        boolean existedBefore = set.contains(1103190229303827372L);
        boolean added = set.add(1103190229303827372L);
        boolean existsAfter = set.contains(1103190229303827372L);
        Assert.assertFalse((String)"1103190229303827372 should not exist before adding here", (boolean)existedBefore);
        Assert.assertTrue((String)"1103190229303827372 should be reported as added here", (boolean)added);
        Assert.assertTrue((String)"1103190229303827372 should exist", (boolean)existsAfter);
    }

    @Test
    public void longVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveLongSet set = Primitive.longSet();
        set.add(1L);
        set.add(2L);
        set.add(3L);
        PrimitiveLongVisitor visitor = (PrimitiveLongVisitor)Mockito.mock(PrimitiveLongVisitor.class);
        set.visitKeys(visitor);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(1L);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(2L);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(3L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void longVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        PrimitiveIntSet map = Primitive.intSet();
        map.add(1);
        map.add(2);
        map.add(3);
        map.add(4);
        AtomicInteger counter = new AtomicInteger();
        map.visitKeys(value -> counter.incrementAndGet() > 2);
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void intVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveIntSet set = Primitive.intSet();
        set.add(1);
        set.add(2);
        set.add(3);
        PrimitiveIntVisitor visitor = (PrimitiveIntVisitor)Mockito.mock(PrimitiveIntVisitor.class);
        set.visitKeys(visitor);
        ((PrimitiveIntVisitor)Mockito.verify((Object)visitor)).visited(1);
        ((PrimitiveIntVisitor)Mockito.verify((Object)visitor)).visited(2);
        ((PrimitiveIntVisitor)Mockito.verify((Object)visitor)).visited(3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void intVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        PrimitiveIntSet map = Primitive.intSet();
        map.add(1);
        map.add(2);
        map.add(3);
        map.add(4);
        AtomicInteger counter = new AtomicInteger();
        map.visitKeys(value -> counter.incrementAndGet() > 2);
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void shouldHandleEmptySet() throws Exception {
        PrimitiveLongSet set = Primitive.longSet((int)0);
        Assert.assertFalse((boolean)set.contains(564L));
    }
}

