/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.LongKeyTable;
import org.neo4j.collection.primitive.hopscotch.PrimitiveLongHashSet;
import org.neo4j.collection.primitive.hopscotch.Table;

public class HopScotchHashingAlgorithmTest {
    @Test
    public void shouldSupportIteratingThroughResize() throws Exception {
        int threshold = this.figureOutGrowthThreshold();
        TableGrowthAwareMonitor monitor = new TableGrowthAwareMonitor();
        PrimitiveLongHashSet set = new PrimitiveLongHashSet((Table)new LongKeyTable(32, Primitive.VALUE_MARKER), Primitive.VALUE_MARKER, (HopScotchHashingAlgorithm.Monitor)monitor);
        HashSet<Long> added = new HashSet<Long>();
        for (long i = 0L; i < (long)(threshold - 1); ++i) {
            long value = i * 3L;
            set.add(value);
            added.add(value);
        }
        PrimitiveLongIterator iterator = set.iterator();
        HashSet<Long> iterated = new HashSet<Long>();
        for (int i = 0; i < threshold / 2; ++i) {
            iterated.add(iterator.next());
        }
        Assert.assertFalse((boolean)monitor.checkAndReset());
        set.add((long)((threshold - 1) * 3));
        Assert.assertTrue((boolean)monitor.checkAndReset());
        while (iterator.hasNext()) {
            iterated.add(iterator.next());
        }
        Assert.assertEquals(added, iterated);
    }

    private int figureOutGrowthThreshold() {
        final AtomicBoolean grew = new AtomicBoolean();
        HopScotchHashingAlgorithm.Monitor.Adapter monitor = new HopScotchHashingAlgorithm.Monitor.Adapter(){

            public boolean tableGrew(int fromCapacity, int toCapacity, int currentSize) {
                grew.set(true);
                return true;
            }
        };
        try (PrimitiveLongHashSet set = new PrimitiveLongHashSet((Table)new LongKeyTable(32, Primitive.VALUE_MARKER), Primitive.VALUE_MARKER, (HopScotchHashingAlgorithm.Monitor)monitor);){
            int i = 0;
            i = 0;
            while (!grew.get()) {
                set.add((long)(i * 3));
                ++i;
            }
            int n = i;
            return n;
        }
    }

    private static class TableGrowthAwareMonitor
    extends HopScotchHashingAlgorithm.Monitor.Adapter {
        private boolean grew;

        private TableGrowthAwareMonitor() {
        }

        public boolean tableGrew(int fromCapacity, int toCapacity, int currentSize) {
            this.grew = true;
            return true;
        }

        public boolean checkAndReset() {
            try {
                boolean bl = this.grew;
                return bl;
            }
            finally {
                this.grew = false;
            }
        }
    }
}

