/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntLongMap;
import org.neo4j.collection.primitive.PrimitiveIntLongVisitor;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectVisitor;
import org.neo4j.collection.primitive.PrimitiveIntVisitor;
import org.neo4j.collection.primitive.PrimitiveLongIntMap;
import org.neo4j.collection.primitive.PrimitiveLongIntVisitor;
import org.neo4j.collection.primitive.PrimitiveLongLongMap;
import org.neo4j.collection.primitive.PrimitiveLongLongVisitor;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;

public class PrimitiveLongMapTest {
    @Test
    public void shouldContainAddedValues() throws Exception {
        HashMap<Long, Integer> expectedEntries = new HashMap<Long, Integer>();
        expectedEntries.put(1994703545L, 59);
        expectedEntries.put(1583732120L, 98);
        expectedEntries.put(756530774L, 56);
        expectedEntries.put(1433091763L, 22);
        PrimitiveLongObjectMap map = Primitive.longObjectMap();
        for (Map.Entry entry : expectedEntries.entrySet()) {
            map.put(((Long)entry.getKey()).longValue(), entry.getValue());
        }
        boolean existedBefore = map.containsKey(1433091763L);
        Integer valueBefore = (Integer)map.get(1433091763L);
        Integer previous = (Integer)map.put(1433091763L, (Object)35);
        boolean existsAfter = map.containsKey(1433091763L);
        Integer valueAfter = (Integer)map.get(1433091763L);
        Assert.assertTrue((String)"1433091763 should exist before putting here", (boolean)existedBefore);
        Assert.assertEquals((Object)22, (Object)valueBefore);
        Assert.assertEquals((Object)22, (Object)previous);
        Assert.assertTrue((String)"(1433091763, 35) should exist", (boolean)existsAfter);
        Assert.assertEquals((Object)35, (Object)valueAfter);
        expectedEntries.put(1433091763L, 35);
        HashMap visitedEntries = new HashMap();
        map.visitEntries((key, value) -> {
            visitedEntries.put(key, value);
            return false;
        });
        Assert.assertEquals(expectedEntries, visitedEntries);
    }

    @Test
    public void shouldContainAddedValues_2() throws Exception {
        PrimitiveLongObjectMap map = Primitive.longObjectMap();
        map.put(1950736976L, (Object)4);
        map.put(1054824202L, (Object)58);
        map.put(348690619L, (Object)54);
        map.put(1224909480L, (Object)79);
        map.put(1508493474L, (Object)82);
        boolean existedBefore = map.containsKey(1508493474L);
        Integer valueBefore = (Integer)map.get(1508493474L);
        Integer previous = (Integer)map.put(1508493474L, (Object)62);
        boolean existsAfter = map.containsKey(1508493474L);
        Integer valueAfter = (Integer)map.get(1508493474L);
        Assert.assertTrue((String)"1508493474 should exist before putting here", (boolean)existedBefore);
        Assert.assertEquals((String)"value before should be 82", (Object)82, (Object)valueBefore);
        Assert.assertEquals((String)"value returned from put should be 82", (Object)82, (Object)previous);
        Assert.assertTrue((String)"1508493474 should exist", (boolean)existsAfter);
        Assert.assertEquals((String)"value after putting should be 62", (Object)62, (Object)valueAfter);
    }

    @Test
    public void shouldContainAddedValues_3() throws Exception {
        PrimitiveLongObjectMap map = Primitive.longObjectMap();
        map.remove(1338037218L);
        map.put(680125236L, (Object)83);
        map.put(680125236L, (Object)76);
        map.put(680125236L, (Object)47);
        map.put(680125236L, (Object)30);
        map.put(2080483597L, (Object)52);
        map.put(867107519L, (Object)80);
        map.remove(710100384L);
        map.put(671477921L, (Object)88);
        map.put(1163609643L, (Object)17);
        map.put(680125236L, (Object)57);
        map.put(1163609643L, (Object)70);
        map.put(2080483597L, (Object)89);
        map.put(1472451898L, (Object)62);
        map.put(1379499183L, (Object)93);
        map.put(680125236L, (Object)17);
        map.put(567842571L, (Object)43);
        map.put(2045599221L, (Object)60);
        map.remove(641295711L);
        map.remove(867107519L);
        map.put(2045599221L, (Object)30);
        map.remove(2094689486L);
        map.put(1572965945L, (Object)79);
        map.remove(1329473388L);
        map.put(1572965945L, (Object)39);
        map.put(264067586L, (Object)60);
        map.put(1751846500L, (Object)5);
        map.put(1163609643L, (Object)25);
        map.put(1379499183L, (Object)54);
        map.remove(671477921L);
        map.put(1572965945L, (Object)59);
        map.put(880140639L, (Object)87);
        boolean existedBefore = map.containsKey(468007595L);
        Integer valueBefore = (Integer)map.get(468007595L);
        Integer previous = (Integer)map.put(468007595L, (Object)67);
        boolean existsAfter = map.containsKey(468007595L);
        Integer valueAfter = (Integer)map.get(468007595L);
        Assert.assertFalse((String)"468007595 should not exist before putting here", (boolean)existedBefore);
        Assert.assertNull((String)"value before putting should be null", (Object)valueBefore);
        Assert.assertNull((String)"value returned from putting should be null", (Object)previous);
        Assert.assertTrue((String)"468007595 should exist", (boolean)existsAfter);
        Assert.assertEquals((String)"value after putting should be 67", (Object)67, (Object)valueAfter);
    }

    @Test
    public void shouldHaveCorrectSize() throws Exception {
        PrimitiveLongObjectMap map = Primitive.longObjectMap();
        map.put(152407843L, (Object)17);
        map.put(435803197L, (Object)29);
        map.put(2063473573L, (Object)75);
        map.put(162922679L, (Object)36);
        map.put(923042422L, (Object)47);
        map.put(204556993L, (Object)28);
        map.put(109670524L, (Object)80);
        map.put(0xCC35353L, (Object)88);
        map.put(297958695L, (Object)97);
        map.put(873122371L, (Object)73);
        map.put(398704786L, (Object)25);
        map.put(376378917L, (Object)62);
        map.put(1948985185L, (Object)3);
        map.put(918339266L, (Object)4);
        map.put(1126937431L, (Object)48);
        map.put(568627750L, (Object)6);
        map.put(887668742L, (Object)1);
        map.put(888089153L, (Object)88);
        map.put(1671871078L, (Object)26);
        map.put(479217936L, (Object)11);
        map.put(1874408328L, (Object)56);
        map.put(1517450283L, (Object)83);
        map.put(1352952211L, (Object)57);
        map.put(686066722L, (Object)92);
        map.put(1593196310L, (Object)71);
        map.put(1535351391L, (Object)62);
        map.put(296560052L, (Object)59);
        map.put(1513542622L, (Object)49);
        map.put(1899330306L, (Object)57);
        map.put(746190595L, (Object)31);
        map.put(1216091366L, (Object)90);
        map.put(353922939L, (Object)16);
        map.put(680935464L, (Object)16);
        map.put(235368309L, (Object)8);
        map.put(1988133681L, (Object)32);
        map.put(330747855L, (Object)81);
        map.put(492627887L, (Object)74);
        map.put(1005495348L, (Object)8);
        map.put(2107419277L, (Object)82);
        map.put(1421265494L, (Object)15);
        map.put(1669915469L, (Object)92);
        map.put(2008247215L, (Object)9);
        map.put(2010142383L, (Object)77);
        map.put(829081830L, (Object)25);
        map.put(1349259272L, (Object)38);
        map.put(1987482877L, (Object)8);
        map.put(974334859L, (Object)83);
        map.put(1376908873L, (Object)10);
        map.put(2120105656L, (Object)22);
        map.put(1634193445L, (Object)8);
        map.put(1160987255L, (Object)34);
        map.put(2030156381L, (Object)16);
        map.put(2012943328L, (Object)22);
        map.put(75749275L, (Object)54);
        map.put(1415817090L, (Object)35);
        map.put(562352348L, (Object)43);
        map.put(658501173L, (Object)96);
        map.put(441278652L, (Object)24);
        map.put(633855945L, (Object)82);
        map.put(579807215L, (Object)31);
        map.put(1125922962L, (Object)33);
        map.put(1995076951L, (Object)91);
        map.put(322776761L, (Object)4);
        map.put(1011369342L, (Object)36);
        int sizeBefore = map.size();
        boolean existedBefore = map.containsKey(679686325L);
        Integer valueBefore = (Integer)map.get(679686325L);
        Integer previous = (Integer)map.put(679686325L, (Object)63);
        boolean existsAfter = map.containsKey(679686325L);
        Integer valueAfter = (Integer)map.get(679686325L);
        int sizeAfter = map.size();
        Assert.assertEquals((String)"Size before put should have been 64", (long)64L, (long)sizeBefore);
        Assert.assertFalse((String)"679686325 should not exist before putting here", (boolean)existedBefore);
        Assert.assertNull((String)"value before putting should be null", (Object)valueBefore);
        Assert.assertNull((String)"value returned from putting should be null", (Object)previous);
        Assert.assertTrue((String)"679686325 should exist", (boolean)existsAfter);
        Assert.assertEquals((String)"value after putting should be 63", (Object)63, (Object)valueAfter);
        Assert.assertEquals((String)"Size after put should have been 65", (long)65L, (long)sizeAfter);
    }

    @Test
    public void shouldMoveValuesWhenMovingEntriesAround() throws Exception {
        PrimitiveLongObjectMap map = Primitive.longObjectMap();
        map.put(206243105L, (Object)47);
        map.put(2083304695L, (Object)63);
        map.put(689837337L, (Object)7);
        map.remove(206243105L);
        int sizeBefore = map.size();
        boolean existedBefore = map.containsKey(689837337L);
        Integer valueBefore = (Integer)map.get(689837337L);
        Integer previous = (Integer)map.put(689837337L, (Object)20);
        boolean existsAfter = map.containsKey(689837337L);
        Integer valueAfter = (Integer)map.get(689837337L);
        int sizeAfter = map.size();
        Assert.assertEquals((String)"Size before put should have been 2", (long)2L, (long)sizeBefore);
        Assert.assertTrue((String)"689837337 should exist before putting here", (boolean)existedBefore);
        Assert.assertEquals((String)"value before should be 7", (Object)7, (Object)valueBefore);
        Assert.assertEquals((String)"value returned from put should be 7", (Object)7, (Object)previous);
        Assert.assertTrue((String)"689837337 should exist", (boolean)existsAfter);
        Assert.assertEquals((String)"value after putting should be 20", (Object)20, (Object)valueAfter);
        Assert.assertEquals((String)"Size after put should have been 2", (long)2L, (long)sizeAfter);
    }

    @Test
    public void shouldReturnCorrectPreviousValue() throws Exception {
        PrimitiveLongIntMap map = Primitive.longIntMap();
        map.remove(2050585513L);
        map.put(429170228L, 99);
        map.put(1356282827L, 24);
        map.remove(1341095873L);
        int sizeBefore = map.size();
        boolean existedBefore = map.containsKey(429170228L);
        int valueBefore = map.get(429170228L);
        int previous = map.put(429170228L, 1);
        boolean existsAfter = map.containsKey(429170228L);
        int valueAfter = map.get(429170228L);
        int sizeAfter = map.size();
        Assert.assertEquals((String)"Size before put should have been 2", (long)2L, (long)sizeBefore);
        Assert.assertTrue((String)"429170228 should exist before putting here", (boolean)existedBefore);
        Assert.assertEquals((String)"value before should be 99", (long)99L, (long)valueBefore);
        Assert.assertEquals((String)"value returned from put should be 99", (long)99L, (long)previous);
        Assert.assertTrue((String)"429170228 should exist", (boolean)existsAfter);
        Assert.assertEquals((String)"value after putting should be 1", (long)1L, (long)valueAfter);
        Assert.assertEquals((String)"Size after put should have been 2", (long)2L, (long)sizeAfter);
    }

    @Test
    public void shouldOnlyContainAddedValues() throws Exception {
        PrimitiveLongIntMap map = Primitive.longIntMap();
        map.put(1179059774L, 54);
        map.put(612612792L, 91);
        map.put(853030395L, 81);
        map.put(1821941016L, 69);
        map.put(815540261L, 54);
        map.put(2120470777L, 63);
        map.put(866144206L, 41);
        map.put(905659306L, 86);
        map.put(602586792L, 24);
        map.put(1033857549L, 61);
        map.put(1570231638L, 69);
        map.put(30675820L, 53);
        map.put(433666923L, 14);
        map.put(1668952952L, 52);
        map.put(1733960171L, 14);
        map.put(1240027317L, 64);
        map.put(250830995L, 71);
        map.put(1446519846L, 17);
        map.put(1857052106L, 78);
        map.put(37351838L, 26);
        map.put(1523695604L, 78);
        map.put(1024540180L, 12);
        map.put(603632507L, 81);
        map.put(483087335L, 37);
        map.put(216300592L, 55);
        map.put(1729046213L, 72);
        map.put(1397559084L, 78);
        map.put(802042428L, 34);
        map.put(1127990805L, 6);
        map.put(2081866795L, 53);
        map.put(1528122026L, 39);
        map.put(642547543L, 78);
        map.put(1909701557L, 35);
        map.put(2070740876L, 40);
        map.put(316027755L, 18);
        map.put(824089651L, 63);
        map.put(1082682044L, 85);
        map.put(154864377L, 44);
        map.put(26918244L, 73);
        map.put(808069768L, 20);
        map.put(38089155L, 17);
        map.put(1772700678L, 35);
        map.put(1790535392L, 82);
        map.put(159186757L, 10);
        map.put(73305650L, 52);
        map.put(2025019209L, 38);
        map.put(922996536L, 53);
        map.put(1852424925L, 34);
        map.put(1181179273L, 9);
        map.put(107520967L, 11);
        map.put(1702904247L, 55);
        map.put(1819417390L, 50);
        map.put(1163114165L, 57);
        map.put(2036796587L, 40);
        map.put(2130510197L, 26);
        map.put(1710533919L, 70);
        map.put(497498438L, 48);
        map.put(147722732L, 8);
        map.remove(802042428L);
        map.put(1355114893L, 90);
        map.put(419675404L, 62);
        map.put(1722846265L, 41);
        map.put(1287254514L, 61);
        map.put(1925017947L, 8);
        map.put(1290391303L, 59);
        map.put(1938779966L, 27);
        int sizeBefore = map.size();
        boolean existedBefore = map.containsKey(1452811669L);
        int valueBefore = map.get(1452811669L);
        int previous = map.put(1452811669L, 16);
        boolean existsAfter = map.containsKey(1452811669L);
        int valueAfter = map.get(1452811669L);
        int sizeAfter = map.size();
        Assert.assertEquals((String)"Size before put should have been 64", (long)64L, (long)sizeBefore);
        Assert.assertFalse((String)"1452811669 should not exist before putting here", (boolean)existedBefore);
        Assert.assertEquals((String)"value before should be -1", (long)-1L, (long)valueBefore);
        Assert.assertEquals((String)"value returned from put should be -1", (long)-1L, (long)previous);
        Assert.assertTrue((String)"1452811669 should exist", (boolean)existsAfter);
        Assert.assertEquals((String)"value after putting should be 16", (long)16L, (long)valueAfter);
        Assert.assertEquals((String)"Size after put should have been 65", (long)65L, (long)sizeAfter);
    }

    @Test
    public void shouldOnlyContainAddedValues_2() throws Exception {
        PrimitiveLongIntMap map = Primitive.longIntMap();
        map.put(913910231L, 25);
        map.put(102310782L, 40);
        map.put(634960377L, 32);
        map.put(947168147L, 96);
        map.put(947430652L, 26);
        map.put(1391472521L, 72);
        map.put(7905512L, 10);
        map.put(7905512L, 2);
        map.put(1391472521L, 66);
        map.put(824376092L, 79);
        map.remove(750639810L);
        map.put(947168147L, 61);
        map.put(831409018L, 57);
        map.put(241941283L, 76);
        map.put(824376092L, 45);
        map.remove(2125994926L);
        map.put(824376092L, 47);
        map.put(1477982280L, 1);
        map.remove(2129508263L);
        map.put(1477982280L, 41);
        map.put(642178985L, 69);
        map.put(1447441709L, 85);
        map.put(642178985L, 27);
        map.put(875840384L, 72);
        map.put(1967716733L, 55);
        map.put(1965379174L, 5);
        map.put(913910231L, 40);
        boolean existedBefore = map.containsKey(947430652L);
        int valueBefore = map.get(947430652L);
        int removed = map.remove(947430652L);
        boolean existsAfter = map.containsKey(947430652L);
        int valueAfter = map.get(947430652L);
        Assert.assertTrue((String)"947430652 should exist before removing here", (boolean)existedBefore);
        Assert.assertEquals((String)"value before should be 26", (long)26L, (long)valueBefore);
        Assert.assertEquals((String)"value returned from remove should be 26", (long)26L, (long)removed);
        Assert.assertFalse((String)"947430652 should not exist", (boolean)existsAfter);
        Assert.assertEquals((String)"value after removing should be -1", (long)-1L, (long)valueAfter);
    }

    @Test
    public void shouldOnlyContainAddedValues_3() throws Exception {
        PrimitiveLongObjectMap map = Primitive.longObjectMap();
        map.put(2083704227957337692L, (Object)50);
        map.put(1039748383662879297L, (Object)12);
        map.put(6296247210943123044L, (Object)45);
        map.put(8004677065031068097L, (Object)5);
        map.put(1039748383662879297L, (Object)70);
        map.put(5386804704064477958L, (Object)97);
        map.remove(1506507783133586973L);
        map.put(4287434858289406631L, (Object)29);
        map.put(8004677065031068097L, (Object)17);
        map.put(986286772325632801L, (Object)14);
        map.put(7880139640446289959L, (Object)68);
        map.put(8004677065031068097L, (Object)23);
        map.put(5386804704064477958L, (Object)72);
        map.put(5386804704064477958L, (Object)71);
        map.put(2300381985575721987L, (Object)0);
        map.put(6144230340727188436L, (Object)31);
        map.put(425423457410117293L, (Object)88);
        map.put(2083704227957337692L, (Object)65);
        map.put(7805027477403310582L, (Object)72);
        map.put(2254081933055750443L, (Object)66);
        map.put(5386804704064477958L, (Object)46);
        map.put(5787098127909281443L, (Object)45);
        map.put(5508645210651400664L, (Object)45);
        map.put(6092264867460428040L, (Object)65);
        map.put(4551026293109220157L, (Object)52);
        map.put(4669163071261559807L, (Object)33);
        map.put(5790325306669462860L, (Object)96);
        map.put(4337317298737908324L, (Object)78);
        map.put(986286772325632801L, (Object)71);
        map.put(4287434858289406631L, (Object)47);
        map.put(1827085004206892313L, (Object)30);
        map.put(6070945099342863711L, (Object)88);
        map.remove(6300957726732252611L);
        map.put(2300381985575721987L, (Object)22);
        map.put(2083704227957337692L, (Object)2);
        map.put(2885272279767063039L, (Object)71);
        map.put(3627867780921264529L, (Object)5);
        map.remove(5330274310754559602L);
        map.put(8902857048431919030L, (Object)23);
        map.remove(4287434858289406631L);
        map.put(5459968256561120197L, (Object)8);
        map.put(5790325306669462860L, (Object)17);
        map.put(9003964541346458616L, (Object)45);
        map.put(3832091967762842783L, (Object)79);
        map.put(1332274446340546922L, (Object)62);
        map.put(6610784890222945257L, (Object)20);
        map.put(3627867780921264529L, (Object)65);
        map.put(7988336790991560848L, (Object)89);
        map.put(5386804704064477958L, (Object)15);
        map.put(6296247210943123044L, (Object)19);
        map.put(7776019112299874624L, (Object)67);
        map.put(5827611175622537127L, (Object)18);
        map.remove(8004677065031068097L);
        map.put(2451971987846333787L, (Object)48);
        map.put(3627867780921264529L, (Object)16);
        map.put(2506727685914893570L, (Object)61);
        map.put(6629089416451699826L, (Object)89);
        map.put(875078333857781813L, (Object)38);
        map.put(439984342972777679L, (Object)51);
        map.put(9077428346047966819L, (Object)19);
        map.put(7045299269724516542L, (Object)73);
        map.put(8055487013098459354L, (Object)24);
        map.put(6610784890222945257L, (Object)65);
        map.put(986286772325632801L, (Object)29);
        map.put(133928815519522465L, (Object)81);
        map.put(5780114596098993316L, (Object)15);
        map.put(3790785290324207363L, (Object)91);
        map.put(2795040354588080479L, (Object)48);
        map.put(4218658174275197144L, (Object)59);
        map.put(6610784890222945257L, (Object)70);
        map.remove(3722940212039795685L);
        map.put(1817899559164238906L, (Object)30);
        map.put(4551026293109220157L, (Object)35);
        map.put(986286772325632801L, (Object)57);
        map.put(3811462607668925015L, (Object)57);
        map.put(2795040354588080479L, (Object)85);
        map.put(8460476221939231932L, (Object)86);
        map.remove(8957537157979159052L);
        map.put(2032224502814063026L, (Object)57);
        map.remove(8924941903092284834L);
        map.put(5386804704064477958L, (Object)2);
        map.put(6629089416451699826L, (Object)18);
        map.put(425423457410117293L, (Object)31);
        map.put(4337317298737908324L, (Object)35);
        map.remove(5337770067730257989L);
        map.put(6150561851033498431L, (Object)49);
        map.put(5067121328094576685L, (Object)46);
        map.remove(3742103310924563011L);
        map.put(1327614778938791146L, (Object)49);
        map.put(255729841510922319L, (Object)16);
        map.put(8785988080128503533L, (Object)69);
        map.put(4218658174275197144L, (Object)20);
        map.put(1265271287408386915L, (Object)43);
        map.put(255729841510922319L, (Object)5);
        map.put(8651736753344997668L, (Object)41);
        map.put(4363375305508283265L, (Object)4);
        map.put(4185381066643227500L, (Object)29);
        map.put(3790785290324207363L, (Object)58);
        map.put(3058911485922749695L, (Object)1);
        map.put(8629268898854377850L, (Object)66);
        map.put(1762013345156514959L, (Object)5);
        map.remove(4354754593499656793L);
        map.put(1332274446340546922L, (Object)16);
        map.put(4953501292937412915L, (Object)87);
        map.put(2330841365833073849L, (Object)83);
        map.put(8096564328797694553L, (Object)44);
        map.put(8935185623148330821L, (Object)7);
        map.put(6150561851033498431L, (Object)48);
        map.remove(5827611175622537127L);
        map.put(8048363335369773749L, (Object)25);
        map.put(3627867780921264529L, (Object)48);
        map.put(4806848030248674690L, (Object)14);
        map.put(5430628648110105698L, (Object)30);
        map.remove(7261476188677343032L);
        map.put(1265271287408386915L, (Object)61);
        map.put(9077428346047966819L, (Object)32);
        map.put(1827085004206892313L, (Object)95);
        map.put(6377023652046870199L, (Object)8);
        map.remove(8096564328797694553L);
        map.put(458594253548258561L, (Object)37);
        map.put(4418108647578170347L, (Object)60);
        map.put(4363375305508283265L, (Object)50);
        map.remove(3220719966247388754L);
        map.put(5067121328094576685L, (Object)86);
        map.put(8030171618634928529L, (Object)9);
        map.remove(5790325306669462860L);
        map.remove(1693435088303118108L);
        map.put(1817899559164238906L, (Object)48);
        map.put(2823063986711596775L, (Object)58);
        map.put(5065867711051034527L, (Object)1);
        map.put(6144553725832876585L, (Object)16);
        map.put(6066303112518690730L, (Object)96);
        map.put(1627429134135319103L, (Object)64);
        map.put(2083704227957337692L, (Object)48);
        map.put(5074984076240598083L, (Object)46);
        map.put(273737562207470342L, (Object)60);
        map.put(5065867711051034527L, (Object)7);
        map.put(1425720210238734727L, (Object)23);
        map.put(8840483239403421070L, (Object)42);
        map.put(622393419539870960L, (Object)66);
        map.put(4649317581471627693L, (Object)84);
        map.put(6344284253098418581L, (Object)10);
        map.put(6066303112518690730L, (Object)14);
        map.put(2032224502814063026L, (Object)72);
        map.put(3860451022347437817L, (Object)26);
        map.put(1931469116507191845L, (Object)30);
        map.put(7264376865632246862L, (Object)81);
        map.put(875078333857781813L, (Object)41);
        map.put(6066303112518690730L, (Object)65);
        map.put(357446231240164192L, (Object)80);
        map.put(90138258774469874L, (Object)73);
        map.put(2550828149718879762L, (Object)72);
        map.put(357446231240164192L, (Object)17);
        map.put(4233359298058523722L, (Object)83);
        map.put(7879882017779927485L, (Object)33);
        map.put(4554977248866184403L, (Object)64);
        map.put(2032224502814063026L, (Object)11);
        map.put(8460476221939231932L, (Object)65);
        map.put(4404294840535520232L, (Object)58);
        map.put(439984342972777679L, (Object)83);
        map.put(143440583901416159L, (Object)59);
        map.put(6980461179076170770L, (Object)9);
        map.put(4253079906814783119L, (Object)93);
        map.put(6377023652046870199L, (Object)20);
        map.put(2885272279767063039L, (Object)5);
        map.put(1115850061381524772L, (Object)37);
        map.put(4288489609244987651L, (Object)22);
        map.put(1869499448099043543L, (Object)73);
        map.put(2233583342469238733L, (Object)84);
        map.put(8785988080128503533L, (Object)61);
        map.put(7396264003126204068L, (Object)81);
        map.put(6553509363155186775L, (Object)96);
        map.put(1265663249510580286L, (Object)89);
        map.put(8824139147632000339L, (Object)49);
        map.put(8629268898854377850L, (Object)10);
        map.put(6463027127151126151L, (Object)57);
        map.put(2577561266405706623L, (Object)46);
        map.put(2942302849662258387L, (Object)40);
        map.put(2233583342469238733L, (Object)56);
        map.put(7971826071187872579L, (Object)53);
        map.put(1425720210238734727L, (Object)27);
        map.remove(7194434791627009043L);
        map.put(1429250394105883546L, (Object)82);
        map.put(8048363335369773749L, (Object)19);
        map.put(425423457410117293L, (Object)51);
        map.remove(3570674569632664356L);
        map.remove(5925614419318569326L);
        map.put(245367449754197583L, (Object)27);
        map.put(8724491045048677021L, (Object)55);
        map.put(1037934857236019066L, (Object)66);
        map.put(8902857048431919030L, (Object)61);
        map.put(4806848030248674690L, (Object)17);
        map.put(8840483239403421070L, (Object)95);
        map.put(2931578375554111170L, (Object)54);
        map.put(5352224688502007093L, (Object)36);
        map.put(6675404627060358866L, (Object)64);
        map.put(5011448804620449550L, (Object)48);
        map.put(9003964541346458616L, (Object)44);
        map.put(8614830761978541860L, (Object)70);
        map.put(3790785290324207363L, (Object)95);
        map.put(3524676886726253569L, (Object)54);
        map.put(6858076293577130289L, (Object)60);
        map.put(6721253107702965701L, (Object)41);
        map.put(655525227420977141L, (Object)94);
        map.put(2344362186561469072L, (Object)29);
        map.put(6144230340727188436L, (Object)76);
        map.put(6751209943070153529L, (Object)22);
        map.put(5528119873376392874L, (Object)44);
        map.put(6675404627060358866L, (Object)20);
        map.put(6167523814676644161L, (Object)50);
        map.put(4288489609244987651L, (Object)82);
        map.remove(3362704467864439992L);
        map.put(8629268898854377850L, (Object)50);
        map.remove(8824139147632000339L);
        map.remove(8563575034946766108L);
        map.put(4391871381220263726L, (Object)20);
        map.remove(6143313773038364355L);
        map.remove(3225044803974988142L);
        map.remove(8048363335369773749L);
        map.remove(439984342972777679L);
        map.put(7776019112299874624L, (Object)8);
        map.put(5414055783993307402L, (Object)13);
        map.put(425423457410117293L, (Object)91);
        map.put(8407567928758710341L, (Object)30);
        map.put(6070945099342863711L, (Object)14);
        map.put(5644323748441073606L, (Object)91);
        map.put(5297141920581728538L, (Object)61);
        map.put(7880139640446289959L, (Object)1);
        map.put(2300381985575721987L, (Object)92);
        map.put(8253246663621301435L, (Object)26);
        map.remove(2074764355175726009L);
        map.remove(3823843425563676964L);
        map.put(8314906688468605292L, (Object)91);
        map.put(6864119235983684905L, (Object)56);
        map.put(6610784890222945257L, (Object)85);
        map.put(3790785290324207363L, (Object)7);
        map.put(9077428346047966819L, (Object)20);
        map.put(5594781060356781714L, (Object)76);
        map.put(4288489609244987651L, (Object)24);
        map.put(5427718399315377322L, (Object)93);
        map.put(6858076293577130289L, (Object)41);
        map.put(4233359298058523722L, (Object)43);
        map.put(3058911485922749695L, (Object)88);
        map.remove(1327614778938791146L);
        map.put(4665341449948530032L, (Object)26);
        map.remove(2860868006143077426L);
        map.put(6167523814676644161L, (Object)70);
        map.remove(8314906688468605292L);
        map.put(6396314739926743170L, (Object)25);
        map.put(8924527320597926970L, (Object)40);
        map.put(1817899559164238906L, (Object)84);
        map.remove(4391871381220263726L);
        map.put(8850817829384121639L, (Object)50);
        map.put(6513548978704592547L, (Object)52);
        map.remove(6066303112518690730L);
        map.remove(3946964103425920940L);
        map.put(7971826071187872579L, (Object)71);
        map.put(90138258774469874L, (Object)78);
        map.put(8309039683334256753L, (Object)44);
        map.put(327300646665050265L, (Object)52);
        map.put(4239841777571533415L, (Object)22);
        map.put(7391753878925882699L, (Object)46);
        map.put(5987501380005333533L, (Object)31);
        map.put(6734545541042861356L, (Object)45);
        map.remove(6566682167801344029L);
        map.put(4218658174275197144L, (Object)16);
        map.put(4363586488886891680L, (Object)88);
        map.put(8030171618634928529L, (Object)19);
        map.put(6513548978704592547L, (Object)95);
        map.put(6721253107702965701L, (Object)55);
        map.put(2153470608693815785L, (Object)9);
        map.put(5807454155419905847L, (Object)7);
        map.remove(4528425347504500078L);
        map.put(339083533777732657L, (Object)72);
        map.put(5162811261582626928L, (Object)68);
        map.put(5459968256561120197L, (Object)89);
        map.put(946125626260258615L, (Object)97);
        map.put(986286772325632801L, (Object)26);
        map.put(8309039683334256753L, (Object)74);
        map.put(1609193622622537433L, (Object)84);
        map.put(2506727685914893570L, (Object)9);
        map.put(143440583901416159L, (Object)33);
        map.put(7716482408003289208L, (Object)30);
        map.put(7880139640446289959L, (Object)74);
        map.put(5472992709007694577L, (Object)27);
        map.put(3367972495572249232L, (Object)8);
        map.put(6002824320296423294L, (Object)71);
        map.put(5162811261582626928L, (Object)10);
        map.remove(8309039683334256753L);
        map.put(3103455156394998975L, (Object)1);
        map.put(4943074037151902792L, (Object)38);
        map.put(1455801901314190156L, (Object)98);
        map.put(3502583509759951230L, (Object)22);
        map.remove(8464127935014315372L);
        map.put(6858076293577130289L, (Object)35);
        map.put(8487179770790306175L, (Object)5);
        map.put(946125626260258615L, (Object)85);
        map.put(722144778357869055L, (Object)1);
        map.remove(6832604792388788147L);
        map.remove(7879882017779927485L);
        map.put(4636443662717865247L, (Object)98);
        map.put(6950926592851406543L, (Object)12);
        map.put(8536120340569832116L, (Object)73);
        map.put(86730768989854734L, (Object)66);
        map.put(4558683789229895837L, (Object)26);
        map.put(4806848030248674690L, (Object)11);
        map.put(425423457410117293L, (Object)38);
        map.put(8713875164075871710L, (Object)97);
        map.put(3790785290324207363L, (Object)77);
        map.put(4632006356221328093L, (Object)21);
        map.put(7628512490650429100L, (Object)28);
        map.remove(4651124484202085669L);
        map.put(4320012891688937760L, (Object)22);
        map.put(6092264867460428040L, (Object)86);
        map.put(6610784890222945257L, (Object)71);
        map.remove(3515175120945606156L);
        map.put(5787098127909281443L, (Object)10);
        map.put(5057609667342409825L, (Object)50);
        map.put(5903362554916539560L, (Object)75);
        map.remove(5339209082212961633L);
        map.put(3502583509759951230L, (Object)36);
        map.put(4198420341072443663L, (Object)75);
        map.put(5037754181090593008L, (Object)34);
        map.put(39606137866137388L, (Object)19);
        map.remove(622393419539870960L);
        map.put(2783004740411041924L, (Object)79);
        map.put(6232331175163415825L, (Object)72);
        map.put(4367206208262757151L, (Object)33);
        map.remove(5879159150292946046L);
        map.put(722144778357869055L, (Object)80);
        map.put(9006426844471489361L, (Object)92);
        map.put(550025535839604778L, (Object)32);
        map.remove(5855895659233120621L);
        map.put(1455801901314190156L, (Object)24);
        map.put(3860451022347437817L, (Object)81);
        map.put(2672104991948169160L, (Object)57);
        map.remove(3860451022347437817L);
        map.remove(655525227420977141L);
        map.put(2413633498546493443L, (Object)68);
        map.put(4185381066643227500L, (Object)54);
        map.put(1280345971255663584L, (Object)39);
        map.put(5796123963544961504L, (Object)76);
        map.put(1892786158672061630L, (Object)55);
        map.remove(5352224688502007093L);
        map.put(3711105805930144213L, (Object)47);
        map.put(4608237982157900285L, (Object)41);
        map.put(4175794211341763944L, (Object)31);
        map.put(2315250912582233395L, (Object)81);
        map.put(357446231240164192L, (Object)87);
        map.put(4110861648946406824L, (Object)75);
        map.put(6912381889380280106L, (Object)22);
        map.put(6721253107702965701L, (Object)43);
        map.put(8536120340569832116L, (Object)87);
        map.put(9134483648483594929L, (Object)77);
        map.put(9132976039160654816L, (Object)69);
        map.remove(7698175804504341415L);
        map.remove(9134483648483594929L);
        map.put(215721718639621876L, (Object)11);
        map.put(8367455298026304238L, (Object)78);
        map.put(215721718639621876L, (Object)13);
        map.put(1398628381776162625L, (Object)12);
        map.put(3818698536247649025L, (Object)91);
        map.put(146020861698406718L, (Object)41);
        map.put(39606137866137388L, (Object)93);
        map.put(2032224502814063026L, (Object)29);
        map.remove(6363504799104250810L);
        map.put(7198198302699040275L, (Object)75);
        map.put(1659665859871881503L, (Object)35);
        map.put(2032224502814063026L, (Object)25);
        map.put(7006780191094382053L, (Object)2);
        map.put(2626850727701928459L, (Object)97);
        map.put(5371963064889126677L, (Object)49);
        map.put(2777831232791546183L, (Object)35);
        map.remove(1265271287408386915L);
        map.remove(1078791602714388223L);
        map.put(7355915493826998767L, (Object)39);
        map.remove(1557741259882614531L);
        map.put(318456745029053198L, (Object)18);
        map.put(5731549637584761783L, (Object)77);
        map.put(875078333857781813L, (Object)80);
        map.remove(4288489609244987651L);
        map.put(6296247210943123044L, (Object)67);
        map.put(6513548978704592547L, (Object)60);
        map.put(7484688824700837146L, (Object)79);
        map.put(4551026293109220157L, (Object)77);
        map.put(2961669147182343860L, (Object)80);
        map.put(4481942776688563562L, (Object)28);
        map.put(5879809531485088687L, (Object)63);
        map.put(5799223884087101214L, (Object)94);
        map.put(8394473765965282856L, (Object)59);
        map.remove(7273585073251585620L);
        map.remove(5518575735665118270L);
        map.put(1946691597339845823L, (Object)64);
        map.put(1191724556568067952L, (Object)33);
        map.remove(1803989601564179749L);
        map.put(7909563548070411816L, (Object)98);
        int sizeBefore = map.size();
        boolean existedBefore = map.containsKey(5826258075197365143L);
        Integer valueBefore = (Integer)map.get(5826258075197365143L);
        Integer previous = (Integer)map.put(5826258075197365143L, (Object)6);
        boolean existsAfter = map.containsKey(5826258075197365143L);
        Integer valueAfter = (Integer)map.get(5826258075197365143L);
        int sizeAfter = map.size();
        Assert.assertEquals((String)"Size before put should have been 199", (long)199L, (long)sizeBefore);
        Assert.assertFalse((String)"5826258075197365143 should not exist before putting here", (boolean)existedBefore);
        Assert.assertNull((String)"value before putting should be null", (Object)valueBefore);
        Assert.assertNull((String)"value returned from putting should be null", (Object)previous);
        Assert.assertTrue((String)"5826258075197365143 should exist", (boolean)existsAfter);
        Assert.assertEquals((String)"value after putting should be 6", (Object)6, (Object)valueAfter);
        Assert.assertEquals((String)"Size after put should have been 200", (long)200L, (long)sizeAfter);
    }

    @Test
    public void longIntEntryVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveLongIntMap map = Primitive.longIntMap();
        map.put(1L, 100);
        map.put(2L, 200);
        map.put(3L, 300);
        PrimitiveLongIntVisitor visitor = (PrimitiveLongIntVisitor)Mockito.mock(PrimitiveLongIntVisitor.class);
        map.visitEntries(visitor);
        ((PrimitiveLongIntVisitor)Mockito.verify((Object)visitor)).visited(1L, 100);
        ((PrimitiveLongIntVisitor)Mockito.verify((Object)visitor)).visited(2L, 200);
        ((PrimitiveLongIntVisitor)Mockito.verify((Object)visitor)).visited(3L, 300);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void longIntEntryVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        PrimitiveLongIntMap map = Primitive.longIntMap();
        map.put(1L, 100);
        map.put(2L, 200);
        map.put(3L, 300);
        map.put(4L, 400);
        AtomicInteger counter = new AtomicInteger();
        map.visitEntries((key, value) -> counter.incrementAndGet() > 2);
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void intLongEntryVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveIntLongMap map = Primitive.intLongMap();
        map.put(1, 100L);
        map.put(2, 200L);
        map.put(3, 300L);
        PrimitiveIntLongVisitor visitor = (PrimitiveIntLongVisitor)Mockito.mock(PrimitiveIntLongVisitor.class);
        map.visitEntries(visitor);
        ((PrimitiveIntLongVisitor)Mockito.verify((Object)visitor)).visited(1, 100L);
        ((PrimitiveIntLongVisitor)Mockito.verify((Object)visitor)).visited(2, 200L);
        ((PrimitiveIntLongVisitor)Mockito.verify((Object)visitor)).visited(3, 300L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void intLongEntryVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        PrimitiveIntLongMap map = Primitive.intLongMap();
        map.put(1, 100L);
        map.put(2, 200L);
        map.put(3, 300L);
        map.put(4, 400L);
        AtomicInteger counter = new AtomicInteger();
        map.visitEntries((key, value) -> counter.incrementAndGet() > 2);
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void longLongEntryVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveLongLongVisitor visitor;
        try (PrimitiveLongLongMap map = Primitive.longLongMap();){
            map.put(1L, 100L);
            map.put(2L, 200L);
            map.put(3L, 300L);
            visitor = (PrimitiveLongLongVisitor)Mockito.mock(PrimitiveLongLongVisitor.class);
            map.visitEntries(visitor);
        }
        ((PrimitiveLongLongVisitor)Mockito.verify((Object)visitor)).visited(1L, 100L);
        ((PrimitiveLongLongVisitor)Mockito.verify((Object)visitor)).visited(2L, 200L);
        ((PrimitiveLongLongVisitor)Mockito.verify((Object)visitor)).visited(3L, 300L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void longLongEntryVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        AtomicInteger counter = new AtomicInteger();
        try (PrimitiveLongLongMap map = Primitive.longLongMap();){
            map.put(1L, 100L);
            map.put(2L, 200L);
            map.put(3L, 300L);
            map.put(4L, 400L);
            map.visitEntries((key, value) -> counter.incrementAndGet() > 2);
        }
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void longLongOffHeapEntryVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveLongLongVisitor visitor;
        try (PrimitiveLongLongMap map = Primitive.offHeapLongLongMap();){
            map.put(1L, 100L);
            map.put(2L, 200L);
            map.put(3L, 300L);
            visitor = (PrimitiveLongLongVisitor)Mockito.mock(PrimitiveLongLongVisitor.class);
            map.visitEntries(visitor);
        }
        ((PrimitiveLongLongVisitor)Mockito.verify((Object)visitor)).visited(1L, 100L);
        ((PrimitiveLongLongVisitor)Mockito.verify((Object)visitor)).visited(2L, 200L);
        ((PrimitiveLongLongVisitor)Mockito.verify((Object)visitor)).visited(3L, 300L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void longLongOffHeapEntryVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        AtomicInteger counter = new AtomicInteger();
        try (PrimitiveLongLongMap map = Primitive.offHeapLongLongMap();){
            map.put(1L, 100L);
            map.put(2L, 200L);
            map.put(3L, 300L);
            map.put(4L, 400L);
            map.visitEntries((key, value) -> counter.incrementAndGet() > 2);
        }
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void longObjectEntryVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveLongObjectMap map = Primitive.longObjectMap();
        map.put(1L, (Object)100);
        map.put(2L, (Object)200);
        map.put(3L, (Object)300);
        PrimitiveLongObjectVisitor visitor = (PrimitiveLongObjectVisitor)Mockito.mock(PrimitiveLongObjectVisitor.class);
        map.visitEntries(visitor);
        ((PrimitiveLongObjectVisitor)Mockito.verify((Object)visitor)).visited(1L, (Object)100);
        ((PrimitiveLongObjectVisitor)Mockito.verify((Object)visitor)).visited(2L, (Object)200);
        ((PrimitiveLongObjectVisitor)Mockito.verify((Object)visitor)).visited(3L, (Object)300);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void longObjectEntryVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        PrimitiveLongObjectMap map = Primitive.longObjectMap();
        map.put(1L, (Object)100);
        map.put(2L, (Object)200);
        map.put(3L, (Object)300);
        map.put(4L, (Object)400);
        AtomicInteger counter = new AtomicInteger();
        map.visitEntries((key, value) -> counter.incrementAndGet() > 2);
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void intObjectEntryVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveIntObjectMap map = Primitive.intObjectMap();
        map.put(1, (Object)100);
        map.put(2, (Object)200);
        map.put(3, (Object)300);
        PrimitiveIntObjectVisitor visitor = (PrimitiveIntObjectVisitor)Mockito.mock(PrimitiveIntObjectVisitor.class);
        map.visitEntries(visitor);
        ((PrimitiveIntObjectVisitor)Mockito.verify((Object)visitor)).visited(1, (Object)100);
        ((PrimitiveIntObjectVisitor)Mockito.verify((Object)visitor)).visited(2, (Object)200);
        ((PrimitiveIntObjectVisitor)Mockito.verify((Object)visitor)).visited(3, (Object)300);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void intObjectEntryVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        PrimitiveIntObjectMap map = Primitive.intObjectMap();
        map.put(1, (Object)100);
        map.put(2, (Object)200);
        map.put(3, (Object)300);
        map.put(4, (Object)400);
        AtomicInteger counter = new AtomicInteger();
        map.visitEntries((key, value) -> counter.incrementAndGet() > 2);
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void longIntKeyVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveLongIntMap map = Primitive.longIntMap();
        map.put(1L, 100);
        map.put(2L, 200);
        map.put(3L, 300);
        PrimitiveLongVisitor visitor = (PrimitiveLongVisitor)Mockito.mock(PrimitiveLongVisitor.class);
        map.visitKeys(visitor);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(1L);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(2L);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(3L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void longIntKeyVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        PrimitiveLongIntMap map = Primitive.longIntMap();
        map.put(1L, 100);
        map.put(2L, 200);
        map.put(3L, 300);
        map.put(4L, 400);
        AtomicInteger counter = new AtomicInteger();
        map.visitKeys(value -> counter.incrementAndGet() > 2);
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void longLongKeyVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveLongVisitor visitor = (PrimitiveLongVisitor)Mockito.mock(PrimitiveLongVisitor.class);
        try (PrimitiveLongLongMap map = Primitive.longLongMap();){
            map.put(1L, 100L);
            map.put(2L, 200L);
            map.put(3L, 300L);
            map.visitKeys(visitor);
        }
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(1L);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(2L);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(3L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void longLongKeyVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        AtomicInteger counter = new AtomicInteger();
        try (PrimitiveLongLongMap map = Primitive.longLongMap();){
            map.put(1L, 100L);
            map.put(2L, 200L);
            map.put(3L, 300L);
            map.put(4L, 400L);
            map.visitKeys(value -> counter.incrementAndGet() > 2);
        }
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void longLongOffHeapKeyVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveLongVisitor visitor = (PrimitiveLongVisitor)Mockito.mock(PrimitiveLongVisitor.class);
        try (PrimitiveLongLongMap map = Primitive.offHeapLongLongMap();){
            map.put(1L, 100L);
            map.put(2L, 200L);
            map.put(3L, 300L);
            map.visitKeys(visitor);
        }
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(1L);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(2L);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(3L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void longLongOffHeapKeyVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        AtomicInteger counter = new AtomicInteger();
        try (PrimitiveLongLongMap map = Primitive.offHeapLongLongMap();){
            map.put(1L, 100L);
            map.put(2L, 200L);
            map.put(3L, 300L);
            map.put(4L, 400L);
            map.visitKeys(value -> counter.incrementAndGet() > 2);
        }
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void longObjectKeyVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveLongObjectMap map = Primitive.longObjectMap();
        map.put(1L, (Object)100);
        map.put(2L, (Object)200);
        map.put(3L, (Object)300);
        PrimitiveLongVisitor visitor = (PrimitiveLongVisitor)Mockito.mock(PrimitiveLongVisitor.class);
        map.visitKeys(visitor);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(1L);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(2L);
        ((PrimitiveLongVisitor)Mockito.verify((Object)visitor)).visited(3L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void longObjectKeyVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        PrimitiveLongObjectMap map = Primitive.longObjectMap();
        map.put(1L, (Object)100);
        map.put(2L, (Object)200);
        map.put(3L, (Object)300);
        map.put(4L, (Object)400);
        AtomicInteger counter = new AtomicInteger();
        map.visitKeys(value -> counter.incrementAndGet() > 2);
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void intObjectKeyVisitorShouldSeeAllEntriesIfItDoesNotBreakOut() {
        PrimitiveIntObjectMap map = Primitive.intObjectMap();
        map.put(1, (Object)100);
        map.put(2, (Object)200);
        map.put(3, (Object)300);
        PrimitiveIntVisitor visitor = (PrimitiveIntVisitor)Mockito.mock(PrimitiveIntVisitor.class);
        map.visitKeys(visitor);
        ((PrimitiveIntVisitor)Mockito.verify((Object)visitor)).visited(1);
        ((PrimitiveIntVisitor)Mockito.verify((Object)visitor)).visited(2);
        ((PrimitiveIntVisitor)Mockito.verify((Object)visitor)).visited(3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void intObjectKeyVisitorShouldNotSeeEntriesAfterRequestingBreakOut() {
        PrimitiveIntObjectMap map = Primitive.intObjectMap();
        map.put(1, (Object)100);
        map.put(2, (Object)200);
        map.put(3, (Object)300);
        map.put(4, (Object)400);
        AtomicInteger counter = new AtomicInteger();
        map.visitKeys(value -> counter.incrementAndGet() > 2);
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void recursivePutGrowInterleavingShouldNotDropOriginalValues() {
        List<Long> lst = Arrays.asList(44988L, 44868L, 44271L, 44399L, 44502L, 44655L, 44348L, 44843L, 44254L, 44774L, 44476L, 44664L, 44485L, 44237L, 44953L, 44468L, 44970L, 44808L, 44527L, 44987L, 44672L, 44647L, 44467L, 44825L, 44740L, 44220L, 44851L, 44902L, 44791L, 44416L, 44365L, 44382L, 44885L, 44510L, 44553L, 44894L, 44288L, 44306L, 44450L, 44689L, 44305L, 44374L, 44323L, 44493L, 44706L, 44681L, 44578L, 44723L, 44331L, 44936L, 44289L, 44919L, 44433L, 44826L, 44757L, 44561L, 44595L, 44612L, 44996L, 44646L, 44834L, 44314L, 44544L, 44629L, 44357L);
        this.verifyMapRetainsAllEntries(lst);
    }

    @Test
    public void recursivePutGrowInterleavingShouldNotDropOriginalValuesEvenWhenFirstGrowAddsMoreValuesAfterSecondGrow() throws Exception {
        List<Long> lst = Arrays.asList(85380L, 85124L, 85252L, 85259L, 85005L, 85260L, 85132L, 85141L, 85397L, 85013L, 85269L, 85277L, 85149L, 85404L, 85022L, 85150L, 85029L, 85414L, 85158L, 85286L, 85421L, 85039L, 85167L, 85294L, 85166L, 85431L, 85303L, 85046L, 85311L, 85439L, 85438L, 85184L, 85056L, 85063L, 85320L, 85448L, 85201L, 85073L, 85329L, 85456L, 85328L, 85337L, 85081L, 85465L, 85080L, 85208L, 85473L, 85218L, 85346L, 85090L, 85097L, 85225L, 85354L, 85098L, 85482L, 85235L, 85363L, 85107L, 85490L, 85115L, 85499L, 85242L, 85175L, 85371L, 85192L);
        this.verifyMapRetainsAllEntries(lst);
    }

    private void verifyMapRetainsAllEntries(List<Long> lst) {
        PrimitiveLongIntMap map = Primitive.longIntMap();
        HashSet<Long> set = new HashSet<Long>();
        for (Long value : lst) {
            Assert.assertThat((Object)map.put(value.longValue(), 1), (Matcher)Matchers.is((Object)-1));
            Assert.assertTrue((boolean)set.add(value));
        }
        Assert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)set.size()));
        for (Long aLong : set) {
            Assert.assertThat((Object)map.get(aLong.longValue()), (Matcher)Matchers.is((Object)1));
        }
    }
}

