/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongList;

public class PrimitiveLongListTest {
    @Test
    public void newListIsEmpty() {
        Assert.assertTrue((boolean)new PrimitiveLongList().isEmpty());
        Assert.assertTrue((boolean)new PrimitiveLongList(12).isEmpty());
    }

    @Test
    public void newListHasZeroSize() {
        Assert.assertEquals((long)0L, (long)new PrimitiveLongList().size());
        Assert.assertEquals((long)0L, (long)new PrimitiveLongList(12).size());
    }

    @Test
    public void addingElementsChangeSize() {
        PrimitiveLongList longList = new PrimitiveLongList();
        longList.add(1L);
        Assert.assertFalse((boolean)longList.isEmpty());
        Assert.assertEquals((long)1L, (long)longList.size());
        longList.add(2L);
        Assert.assertFalse((boolean)longList.isEmpty());
        Assert.assertEquals((long)2L, (long)longList.size());
        longList.add(3L);
        Assert.assertFalse((boolean)longList.isEmpty());
        Assert.assertEquals((long)3L, (long)longList.size());
    }

    @Test
    public void accessAddedElements() {
        PrimitiveLongList longList = new PrimitiveLongList();
        for (long i = 1L; i < 6L; ++i) {
            longList.add(i);
        }
        Assert.assertEquals((long)5L, (long)longList.get(4));
        Assert.assertEquals((long)1L, (long)longList.get(0));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void throwExceptionOnAccessingNonExistentElement() {
        PrimitiveLongList longList = new PrimitiveLongList();
        longList.get(0);
    }

    @Test
    public void iterateOverListElements() {
        PrimitiveLongList longList = new PrimitiveLongList();
        for (long i = 0L; i < 10L; ++i) {
            longList.add(i);
        }
        int iteratorElements = 0;
        long value = 0L;
        PrimitiveLongIterator iterator = longList.iterator();
        while (iterator.hasNext()) {
            ++iteratorElements;
            Assert.assertEquals((long)value++, (long)iterator.next());
        }
        Assert.assertEquals((long)iteratorElements, (long)longList.size());
    }

    @Test
    public void clearResetListSize() {
        PrimitiveLongList longList = new PrimitiveLongList();
        long size = 10L;
        for (long i = 0L; i < 10L; ++i) {
            longList.add(i);
        }
        Assert.assertEquals((long)size, (long)longList.size());
        longList.clear();
        Assert.assertEquals((long)0L, (long)longList.size());
        Assert.assertTrue((boolean)longList.isEmpty());
    }

    @Test
    public void transformListToArray() {
        PrimitiveLongList longList = new PrimitiveLongList();
        long size = 24L;
        for (long i = 0L; i < size; ++i) {
            longList.add(i);
        }
        long[] longs = longList.toArray();
        Assert.assertEquals((long)size, (long)longs.length);
        for (int i = 0; i < longs.length; ++i) {
            Assert.assertEquals((long)i, (long)longs[i]);
        }
    }

    @Test
    public void holdLotsOfElements() {
        PrimitiveLongList longList = new PrimitiveLongList();
        long size = 13077L;
        for (long i = 0L; i < size; ++i) {
            longList.add(i);
        }
        Assert.assertEquals((long)size, (long)longList.size());
        int i = 0;
        while ((long)i < size) {
            Assert.assertEquals((long)i, (long)longList.get(i));
            ++i;
        }
    }
}

