/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;

public class PrimitiveIntCollectionsTest {
    @Test
    public void arrayOfItemsAsIterator() throws Exception {
        int[] items = new int[]{2, 5, 234};
        PrimitiveIntIterator iterator = PrimitiveIntCollections.iterator((int[])items);
        this.assertItems(iterator, items);
    }

    @Test
    public void convertCollectionToLongArray() {
        PrimitiveIntSet heapSet = PrimitiveIntCollections.asSet((int[])new int[]{1, 2, 3});
        PrimitiveIntSet offHeapIntSet = Primitive.offHeapIntSet();
        offHeapIntSet.add(7);
        offHeapIntSet.add(8);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L}, (long[])PrimitiveIntCollections.asLongArray((PrimitiveIntCollection)heapSet));
        Assert.assertArrayEquals((long[])new long[]{7L, 8L}, (long[])PrimitiveIntCollections.asLongArray((PrimitiveIntCollection)offHeapIntSet));
    }

    @Test
    public void arrayOfReversedItemsAsIterator() throws Exception {
        int[] items = new int[]{2, 5, 234};
        PrimitiveIntIterator iterator = PrimitiveIntCollections.reversed((int[])items);
        this.assertItems(iterator, this.reverse(items));
    }

    @Test
    public void concatenateTwoIterators() throws Exception {
        PrimitiveIntIterator firstItems = PrimitiveIntCollections.iterator((int[])new int[]{10, 3, 203, 32});
        PrimitiveIntIterator otherItems = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 5});
        PrimitiveIntIterator iterator = PrimitiveIntCollections.concat(Arrays.asList(firstItems, otherItems).iterator());
        this.assertItems(iterator, 10, 3, 203, 32, 1, 2, 5);
    }

    @Test
    public void prependItem() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{10, 23});
        int prepended = 5;
        PrimitiveIntIterator iterator = PrimitiveIntCollections.prepend((int)prepended, (PrimitiveIntIterator)items);
        this.assertItems(iterator, prepended, 10, 23);
    }

    @Test
    public void appendItem() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2});
        int appended = 3;
        PrimitiveIntIterator iterator = PrimitiveIntCollections.append((PrimitiveIntIterator)items, (int)appended);
        this.assertItems(iterator, 1, 2, appended);
    }

    @Test
    public void filter() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3});
        PrimitiveIntIterator filtered = PrimitiveIntCollections.filter((PrimitiveIntIterator)items, item -> item != 2);
        this.assertItems(filtered, 1, 3);
    }

    @Test
    public void deduplicate() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 1, 2, 3, 2});
        PrimitiveIntIterator deduped = PrimitiveIntCollections.deduplicate((PrimitiveIntIterator)items);
        this.assertItems(deduped, 1, 2, 3);
    }

    @Test
    public void limit() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3});
        PrimitiveIntIterator limited = PrimitiveIntCollections.limit((PrimitiveIntIterator)items, (int)2);
        this.assertItems(limited, 1, 2);
    }

    @Test
    public void skip() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3, 4});
        PrimitiveIntIterator skipped = PrimitiveIntCollections.skip((PrimitiveIntIterator)items, (int)2);
        this.assertItems(skipped, 3, 4);
    }

    @Test
    public void range() throws Exception {
        PrimitiveIntIterator range = PrimitiveIntCollections.range((int)5, (int)15, (int)3);
        this.assertItems(range, 5, 8, 11, 14);
    }

    @Test
    public void singleton() throws Exception {
        int item = 15;
        PrimitiveIntIterator singleton = PrimitiveIntCollections.singleton((int)item);
        this.assertItems(singleton, item);
    }

    @Test
    public void reversed() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3});
        PrimitiveIntIterator reversed = PrimitiveIntCollections.reversed((PrimitiveIntIterator)items);
        this.assertItems(reversed, 3, 2, 1);
    }

    @Test
    public void first() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2});
        try {
            PrimitiveIntCollections.first((PrimitiveIntIterator)PrimitiveIntCollections.emptyIterator());
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        long first = PrimitiveIntCollections.first((PrimitiveIntIterator)items);
        Assert.assertEquals((long)1L, (long)first);
    }

    @Test
    public void firstWithDefault() throws Exception {
        int defaultValue = 5;
        int firstOnEmpty = PrimitiveIntCollections.first((PrimitiveIntIterator)PrimitiveIntCollections.emptyIterator(), (int)defaultValue);
        int first = PrimitiveIntCollections.first((PrimitiveIntIterator)PrimitiveIntCollections.iterator((int[])new int[]{1, 2}), (int)defaultValue);
        Assert.assertEquals((long)defaultValue, (long)firstOnEmpty);
        Assert.assertEquals((long)1L, (long)first);
    }

    @Test
    public void last() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2});
        try {
            PrimitiveIntCollections.last((PrimitiveIntIterator)PrimitiveIntCollections.emptyIterator());
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        long last = PrimitiveIntCollections.last((PrimitiveIntIterator)items);
        Assert.assertEquals((long)2L, (long)last);
    }

    @Test
    public void lastWithDefault() throws Exception {
        int defaultValue = 5;
        int lastOnEmpty = PrimitiveIntCollections.last((PrimitiveIntIterator)PrimitiveIntCollections.emptyIterator(), (int)defaultValue);
        int last = PrimitiveIntCollections.last((PrimitiveIntIterator)PrimitiveIntCollections.iterator((int[])new int[]{1, 2}), (int)defaultValue);
        Assert.assertEquals((long)defaultValue, (long)lastOnEmpty);
        Assert.assertEquals((long)2L, (long)last);
    }

    @Test
    public void single() throws Exception {
        try {
            PrimitiveIntCollections.single((PrimitiveIntIterator)PrimitiveIntCollections.emptyIterator());
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No"));
        }
        Assert.assertEquals((long)3L, (long)PrimitiveIntCollections.single((PrimitiveIntIterator)PrimitiveIntCollections.iterator((int[])new int[]{3})));
        try {
            PrimitiveIntCollections.single((PrimitiveIntIterator)PrimitiveIntCollections.iterator((int[])new int[]{1, 2}));
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"More than one"));
        }
    }

    @Test
    public void singleWithDefault() throws Exception {
        Assert.assertEquals((long)5L, (long)PrimitiveIntCollections.single((PrimitiveIntIterator)PrimitiveIntCollections.emptyIterator(), (int)5));
        Assert.assertEquals((long)3L, (long)PrimitiveIntCollections.single((PrimitiveIntIterator)PrimitiveIntCollections.iterator((int[])new int[]{3})));
        try {
            PrimitiveIntCollections.single((PrimitiveIntIterator)PrimitiveIntCollections.iterator((int[])new int[]{1, 2}));
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"More than one"));
        }
    }

    @Test
    public void singleMustAutoCloseIterator() {
        AtomicInteger counter = new AtomicInteger();
        CountingPrimitiveIntIteratorResource itr = new CountingPrimitiveIntIteratorResource(PrimitiveIntCollections.iterator((int[])new int[]{13}), counter);
        Assert.assertEquals((long)PrimitiveIntCollections.single((PrimitiveIntIterator)itr), (long)13L);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void singleWithDefaultMustAutoCloseIterator() {
        AtomicInteger counter = new AtomicInteger();
        CountingPrimitiveIntIteratorResource itr = new CountingPrimitiveIntIteratorResource(PrimitiveIntCollections.iterator((int[])new int[]{13}), counter);
        Assert.assertEquals((long)PrimitiveIntCollections.single((PrimitiveIntIterator)itr, (int)2), (long)13L);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void singleMustAutoCloseEmptyIterator() {
        AtomicInteger counter = new AtomicInteger();
        CountingPrimitiveIntIteratorResource itr = new CountingPrimitiveIntIteratorResource(PrimitiveIntCollections.emptyIterator(), counter);
        try {
            PrimitiveIntCollections.single((PrimitiveIntIterator)itr);
            Assert.fail((String)"single() on empty iterator should have thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void singleWithDefaultMustAutoCloseEmptyIterator() {
        AtomicInteger counter = new AtomicInteger();
        CountingPrimitiveIntIteratorResource itr = new CountingPrimitiveIntIteratorResource(PrimitiveIntCollections.emptyIterator(), counter);
        Assert.assertEquals((long)PrimitiveIntCollections.single((PrimitiveIntIterator)itr, (int)2), (long)2L);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void itemAt() throws Exception {
        PrimitiveIntIterable items = () -> PrimitiveIntCollections.iterator((int[])new int[]{10, 20, 30});
        try {
            PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)3);
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No element"));
        }
        try {
            PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)-4);
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"not found"));
        }
        Assert.assertEquals((long)10L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)0));
        Assert.assertEquals((long)20L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)1));
        Assert.assertEquals((long)30L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)2));
        Assert.assertEquals((long)30L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)-1));
        Assert.assertEquals((long)20L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)-2));
        Assert.assertEquals((long)10L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)-3));
    }

    @Test
    public void itemAtWithDefault() throws Exception {
        PrimitiveIntIterable items = () -> PrimitiveIntCollections.iterator((int[])new int[]{10, 20, 30});
        int defaultValue = 55;
        Assert.assertEquals((long)defaultValue, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)3, (int)defaultValue));
        Assert.assertEquals((long)defaultValue, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)-4, (int)defaultValue));
        Assert.assertEquals((long)10L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)0));
        Assert.assertEquals((long)20L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)1));
        Assert.assertEquals((long)30L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)2));
        Assert.assertEquals((long)30L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)-1));
        Assert.assertEquals((long)20L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)-2));
        Assert.assertEquals((long)10L, (long)PrimitiveIntCollections.itemAt((PrimitiveIntIterator)items.iterator(), (int)-3));
    }

    @Test
    public void indexOf() throws Exception {
        PrimitiveIntIterable items = () -> PrimitiveIntCollections.iterator((int[])new int[]{10, 20, 30});
        Assert.assertEquals((long)-1L, (long)PrimitiveIntCollections.indexOf((PrimitiveIntIterator)items.iterator(), (int)55));
        Assert.assertEquals((long)0L, (long)PrimitiveIntCollections.indexOf((PrimitiveIntIterator)items.iterator(), (int)10));
        Assert.assertEquals((long)1L, (long)PrimitiveIntCollections.indexOf((PrimitiveIntIterator)items.iterator(), (int)20));
        Assert.assertEquals((long)2L, (long)PrimitiveIntCollections.indexOf((PrimitiveIntIterator)items.iterator(), (int)30));
    }

    @Test
    public void iteratorsEqual() throws Exception {
        PrimitiveIntIterable items1 = () -> PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3});
        PrimitiveIntIterable items2 = () -> PrimitiveIntCollections.iterator((int[])new int[]{1, 20, 3});
        PrimitiveIntIterable items3 = () -> PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3, 4});
        PrimitiveIntIterable items4 = () -> PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3});
        Assert.assertFalse((boolean)PrimitiveIntCollections.equals((PrimitiveIntIterator)items1.iterator(), (PrimitiveIntIterator)items2.iterator()));
        Assert.assertFalse((boolean)PrimitiveIntCollections.equals((PrimitiveIntIterator)items1.iterator(), (PrimitiveIntIterator)items3.iterator()));
        Assert.assertTrue((boolean)PrimitiveIntCollections.equals((PrimitiveIntIterator)items1.iterator(), (PrimitiveIntIterator)items4.iterator()));
    }

    @Test
    public void iteratorAsSet() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3});
        PrimitiveIntSet set = PrimitiveIntCollections.asSet((PrimitiveIntIterator)items);
        Assert.assertTrue((boolean)set.contains(1));
        Assert.assertTrue((boolean)set.contains(2));
        Assert.assertTrue((boolean)set.contains(3));
        Assert.assertFalse((boolean)set.contains(4));
        try {
            PrimitiveIntCollections.asSet((PrimitiveIntIterator)PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 1}));
            Assert.fail((String)"Should fail on duplicates");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void iteratorAsSetAllowDuplicates() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 1});
        PrimitiveIntSet set = PrimitiveIntCollections.asSetAllowDuplicates((PrimitiveIntIterator)items);
        Assert.assertTrue((boolean)set.contains(1));
        Assert.assertTrue((boolean)set.contains(2));
        Assert.assertFalse((boolean)set.contains(3));
    }

    @Test
    public void count() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3});
        int count = PrimitiveIntCollections.count((PrimitiveIntIterator)items);
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void asArray() throws Exception {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3});
        int[] array = PrimitiveIntCollections.asArray((PrimitiveIntIterator)items);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3}, array));
    }

    @Test
    public void shouldNotContinueToCallNextOnHasNextFalse() throws Exception {
        final AtomicInteger count = new AtomicInteger(2);
        PrimitiveIntCollections.PrimitiveIntBaseIterator iterator = new PrimitiveIntCollections.PrimitiveIntBaseIterator(){

            protected boolean fetchNext() {
                return count.decrementAndGet() >= 0 && this.next(count.get());
            }
        };
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)0L, (long)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)-1L, (long)count.get());
    }

    @Test
    public void shouldDeduplicate() throws Exception {
        int[] array = new int[]{1, 6, 2, 5, 6, 1, 6};
        int[] deduped = PrimitiveIntCollections.deduplicate((int[])array);
        Assert.assertArrayEquals((int[])new int[]{1, 6, 2, 5}, (int[])deduped);
    }

    private void assertNoMoreItems(PrimitiveIntIterator iterator) {
        Assert.assertFalse((String)(iterator + " should have no more items"), (boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)("Invoking next() on " + iterator + " which has no items left should have thrown NoSuchElementException"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void assertNextEquals(long expected, PrimitiveIntIterator iterator) {
        Assert.assertTrue((String)(iterator + " should have had more items"), (boolean)iterator.hasNext());
        Assert.assertEquals((long)expected, (long)iterator.next());
    }

    private void assertItems(PrimitiveIntIterator iterator, int ... expectedItems) {
        int[] nArray = expectedItems;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long expectedItem = nArray[i];
            this.assertNextEquals(expectedItem, iterator);
        }
        this.assertNoMoreItems(iterator);
    }

    private int[] reverse(int[] items) {
        int[] result = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = items[items.length - i - 1];
        }
        return result;
    }

    private static final class CountingPrimitiveIntIteratorResource
    implements PrimitiveIntIterator,
    AutoCloseable {
        private final PrimitiveIntIterator delegate;
        private final AtomicInteger closeCounter;

        private CountingPrimitiveIntIteratorResource(PrimitiveIntIterator delegate, AtomicInteger closeCounter) {
            this.delegate = delegate;
            this.closeCounter = closeCounter;
        }

        @Override
        public void close() throws Exception {
            this.closeCounter.incrementAndGet();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public int next() {
            return this.delegate.next();
        }
    }
}

