/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.randomized;

import java.io.PrintStream;
import java.util.List;
import org.neo4j.test.randomized.Action;
import org.neo4j.test.randomized.LinePrinter;
import org.neo4j.test.randomized.PrintStreamLinePrinter;
import org.neo4j.test.randomized.Printable;
import org.neo4j.test.randomized.RandomizedTester;

public class TestCaseWriter<T, F> {
    private final String testName;
    private final Printable given;
    private final List<Action<T, F>> actions;
    private final Action<T, F> failingAction;
    private final RandomizedTester.TargetFactory<T> targetFactory;

    TestCaseWriter(String testName, Printable given, RandomizedTester.TargetFactory<T> targetFactory, List<Action<T, F>> actions, Action<T, F> failingAction) {
        this.testName = testName;
        this.given = given;
        this.targetFactory = targetFactory;
        this.actions = actions;
        this.failingAction = failingAction;
    }

    public void print(PrintStream out) {
        T target = this.targetFactory.newInstance();
        PrintStreamLinePrinter baseLinePrinter = new PrintStreamLinePrinter(out, 0);
        baseLinePrinter.println("@Test");
        baseLinePrinter.println("public void " + this.testName + "() throws Exception");
        baseLinePrinter.println("{");
        LinePrinter codePrinter = baseLinePrinter.indent();
        codePrinter.println("// GIVEN");
        this.given.print(codePrinter);
        for (Action<T, F> action : this.actions) {
            action.printAsCode(target, codePrinter, false);
            action.apply(target);
        }
        codePrinter.println("");
        codePrinter.println("// WHEN/THEN");
        this.failingAction.printAsCode(target, codePrinter, true);
        baseLinePrinter.println("}");
        out.flush();
    }
}

