/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.test.randomized.Action;
import org.neo4j.test.randomized.LinePrinter;
import org.neo4j.test.randomized.Printable;
import org.neo4j.test.randomized.RandomizedTester;
import org.neo4j.test.randomized.Result;
import org.neo4j.test.randomized.TestResource;

public class PrimitiveLongSetRIT {
    @Test
    public void thoroughlyTestIt() throws Exception {
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        while (System.currentTimeMillis() < endTime) {
            long seed = System.currentTimeMillis();
            Random random = new Random(seed);
            int max = random.nextInt(10000) + 100;
            RandomizedTester<Sets, String> actions = new RandomizedTester<Sets, String>(this.setFactory(), this.actionFactory(random));
            Result<Sets, String> result = actions.run(max);
            if (result.isFailure()) {
                System.out.println("Found failure at " + result);
                actions.testCaseWriter("shouldOnlyContainAddedValues", this.given()).print(System.out);
                System.out.println("Actually, minimal reproducible test of that is...");
                actions.findMinimalReproducible().testCaseWriter("shouldOnlyContainAddedValues", this.given()).print(System.out);
                Assert.fail((String)("Failed, see printed test case for how to reproduce. Seed:" + seed));
            }
            this.fullVerification(result.getTarget(), random);
        }
    }

    private void fullVerification(Sets target, Random random) {
        for (Long value : target.normalSet) {
            Assert.assertTrue((boolean)target.set.contains(value.longValue()));
        }
        for (int i = 0; i < target.normalSet.size(); ++i) {
            Assert.assertFalse((boolean)target.set.contains(this.randomNonExisting(random, target.normalSet)));
        }
    }

    private Printable given() {
        return out -> out.println(PrimitiveLongSet.class.getSimpleName() + " set = " + Primitive.class.getSimpleName() + ".longSet();");
    }

    private RandomizedTester.ActionFactory<Sets, String> actionFactory(Random random) {
        return from -> this.generateAction(random, (Sets)from);
    }

    private RandomizedTester.TargetFactory<Sets> setFactory() {
        return () -> new Sets();
    }

    protected Action<Sets, String> generateAction(Random random, Sets from) {
        boolean anExisting = !from.normalSet.isEmpty() && random.nextInt(3) == 0;
        long value = anExisting ? this.randomExisting(random, from.normalSet) : this.randomNonExisting(random, from.normalSet);
        int typeOfAction = random.nextInt(5);
        if (typeOfAction == 0) {
            return new RemoveAction(value);
        }
        return new AddAction(value);
    }

    private long randomNonExisting(Random random, Set<Long> existing) {
        long value;
        while (existing.contains(value = Math.abs(random.nextLong()))) {
        }
        return value;
    }

    private long randomExisting(Random random, Set<Long> existing) {
        int index = random.nextInt(existing.size()) + 1;
        Iterator<Long> iterator = existing.iterator();
        long value = 0L;
        for (int i = 0; i < index; ++i) {
            value = iterator.next();
        }
        return value;
    }

    private static String capitilize(boolean bool) {
        String string = Boolean.valueOf(bool).toString();
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    private static class Sets
    implements TestResource {
        final Set<Long> normalSet = new HashSet<Long>();
        final PrimitiveLongSet set = Primitive.longSet();

        private Sets() {
        }

        @Override
        public void close() {
            this.set.close();
        }
    }

    private static class RemoveAction
    implements Action<Sets, String> {
        private final long value;

        RemoveAction(long value) {
            this.value = value;
        }

        @Override
        public String apply(Sets target) {
            try {
                boolean alreadyExisting = target.normalSet.contains(this.value);
                PrimitiveLongSet set = target.set;
                boolean existedBefore = set.contains(this.value);
                boolean removed = set.remove(this.value);
                boolean existsAfter = set.contains(this.value);
                target.normalSet.remove(this.value);
                boolean ok = existedBefore == alreadyExisting & removed == alreadyExisting & !existsAfter;
                return ok ? null : "" + this.value + alreadyExisting + "," + existedBefore + "," + removed + "," + existsAfter;
            }
            catch (Exception e) {
                return "exception: " + e.getMessage();
            }
        }

        @Override
        public void printAsCode(Sets source, LinePrinter out, boolean includeChecks) {
            boolean alreadyExisting = source.normalSet.contains(this.value);
            String removal = "set.remove( " + this.value + "L );";
            if (includeChecks) {
                out.println(String.format("boolean existedBefore = set.contains( %dL );", this.value));
                out.println(String.format("boolean removed = %s", removal));
                out.println(String.format("boolean existsAfter = set.contains( %dL );", this.value));
                out.println(String.format("assert%s( \"%s\", existedBefore );", PrimitiveLongSetRIT.capitilize(alreadyExisting), this.value + " should " + (alreadyExisting ? "" : "not ") + "exist before removing here"));
                out.println(String.format("assert%s( \"%s\", removed );", PrimitiveLongSetRIT.capitilize(alreadyExisting), this.value + " should " + (alreadyExisting ? "" : "not ") + "be reported as removed here"));
                out.println(String.format("assertFalse( \"%s\", existsAfter );", this.value + " should not exist"));
            } else {
                out.println(removal);
            }
        }
    }

    private static class AddAction
    implements Action<Sets, String> {
        private final long value;

        AddAction(long value) {
            this.value = value;
        }

        @Override
        public String apply(Sets target) {
            try {
                boolean alreadyExisting = target.normalSet.contains(this.value);
                PrimitiveLongSet set = target.set;
                boolean existedBefore = set.contains(this.value);
                boolean added = set.add(this.value);
                boolean existsAfter = set.contains(this.value);
                target.normalSet.add(this.value);
                boolean ok = existedBefore == alreadyExisting & added == !alreadyExisting & existsAfter;
                return ok ? null : "" + this.value + alreadyExisting + "," + existedBefore + "," + added + "," + existsAfter;
            }
            catch (Exception e) {
                return "exception:" + e.getMessage();
            }
        }

        @Override
        public void printAsCode(Sets source, LinePrinter out, boolean includeChecks) {
            boolean alreadyExisting = source.normalSet.contains(this.value);
            String addition = "set.add( " + this.value + "L );";
            if (includeChecks) {
                out.println(String.format("boolean existedBefore = set.contains( %dL );", this.value));
                out.println(String.format("boolean added = %s", addition));
                out.println(String.format("boolean existsAfter = set.contains( %dL );", this.value));
                out.println(String.format("assert%s( \"%s\", existedBefore );", PrimitiveLongSetRIT.capitilize(alreadyExisting), this.value + " should " + (alreadyExisting ? "" : "not ") + "exist before adding here"));
                out.println(String.format("assert%s( \"%s\", added );", PrimitiveLongSetRIT.capitilize(!alreadyExisting), this.value + " should " + (!alreadyExisting ? "" : "not ") + "be reported as added here"));
                out.println(String.format("assertTrue( \"%s\", existsAfter );", this.value + " should exist"));
            } else {
                out.println(addition);
            }
        }
    }
}

