/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;

class DebugMonitor
extends HopScotchHashingAlgorithm.Monitor.Adapter {
    private final Set<Integer> indexes = new HashSet<Integer>();
    private final Set<Long> values = new HashSet<Long>();

    DebugMonitor(int[] relevantIndexes, long[] relevantValues) {
        for (int index : relevantIndexes) {
            this.indexes.add(index);
        }
        for (long value : relevantValues) {
            this.values.add(value);
        }
    }

    private String hopBitsAsString(long hopBits) {
        StringBuilder builder = new StringBuilder("[");
        while (hopBits > 0L) {
            int indexDistance = Long.numberOfTrailingZeros(hopBits);
            hopBits &= hopBits - 1L;
            builder.append(builder.length() > 1 ? "," : "").append(indexDistance + 1);
        }
        return builder.append("]").toString();
    }

    private String hopBitsAsString(long oldHopBits, long newHopBits) {
        return this.hopBitsAsString(oldHopBits) + " > " + this.hopBitsAsString(newHopBits);
    }

    public boolean placedAtFreedIndex(int intendedIndex, long newHopBits, long key, int actualIndex) {
        if (this.indexes.contains(intendedIndex) || this.indexes.contains(actualIndex) || this.values.contains(key)) {
            System.out.println(String.format("[%d] --> |%d| <-- %d  %s", intendedIndex, actualIndex, key, this.hopBitsAsString(newHopBits)));
        }
        return true;
    }

    public boolean placedAtFreeAndIntendedIndex(long key, int index) {
        if (this.indexes.contains(index) || this.values.contains(key)) {
            System.out.println(String.format("[%d] <-- %d", index, key));
        }
        return true;
    }

    public boolean pushedToFreeIndex(int intendedIndex, long oldNeighborHopBits, long newNeighborHopBits, int neighborIndex, long key, int fromIndex, int toIndex) {
        if (this.indexes.contains(intendedIndex) || this.indexes.contains(neighborIndex) || this.indexes.contains(fromIndex) || this.indexes.contains(toIndex) || this.values.contains(key)) {
            System.out.println(String.format("[%d] --- [%d] -->> [%d] --> %d --> [%d]  %s", intendedIndex, neighborIndex, fromIndex, key, toIndex, this.hopBitsAsString(oldNeighborHopBits, newNeighborHopBits)));
        }
        return true;
    }

    public boolean pulledToFreeIndex(int intendedIndex, long newHopBits, long key, int fromIndex, int toIndex) {
        if (this.indexes.contains(intendedIndex) || this.indexes.contains(fromIndex) || this.indexes.contains(toIndex) || this.values.contains(key)) {
            System.out.println(String.format("[%d] --- [%d] <<-- %d <-- [%d]  %s", intendedIndex, toIndex, key, fromIndex, this.hopBitsAsString(newHopBits)));
        }
        return true;
    }
}

