/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;

public class PrimitiveLongCollectionsTest {
    @Test
    public void arrayOfItemsAsIterator() throws Exception {
        long[] items = new long[]{2L, 5L, 234L};
        PrimitiveLongIterator iterator = PrimitiveLongCollections.iterator((long[])items);
        this.assertItems(iterator, items);
    }

    @Test
    public void arrayOfReversedItemsAsIterator() throws Exception {
        long[] items = new long[]{2L, 5L, 234L};
        PrimitiveLongIterator iterator = PrimitiveLongCollections.reversed((long[])items);
        this.assertItems(iterator, this.reverse(items));
    }

    @Test
    public void concatenateTwoIterators() throws Exception {
        PrimitiveLongIterator firstItems = PrimitiveLongCollections.iterator((long[])new long[]{10L, 3L, 203L, 32L});
        PrimitiveLongIterator otherItems = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 5L});
        PrimitiveLongIterator iterator = PrimitiveLongCollections.concat(Arrays.asList(firstItems, otherItems).iterator());
        this.assertItems(iterator, 10L, 3L, 203L, 32L, 1L, 2L, 5L);
    }

    @Test
    public void prependItem() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{10L, 23L});
        long prepended = 5L;
        PrimitiveLongIterator iterator = PrimitiveLongCollections.prepend((long)prepended, (PrimitiveLongIterator)items);
        this.assertItems(iterator, prepended, 10L, 23L);
    }

    @Test
    public void appendItem() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L});
        long appended = 3L;
        PrimitiveLongIterator iterator = PrimitiveLongCollections.append((PrimitiveLongIterator)items, (long)appended);
        this.assertItems(iterator, 1L, 2L, appended);
    }

    @Test
    public void filter() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        PrimitiveLongIterator filtered = PrimitiveLongCollections.filter((PrimitiveLongIterator)items, item -> item != 2L);
        this.assertItems(filtered, 1L, 3L);
    }

    @Test
    public void deduplicate() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 1L, 2L, 3L, 2L});
        PrimitiveLongIterator deduped = PrimitiveLongCollections.deduplicate((PrimitiveLongIterator)items);
        this.assertItems(deduped, 1L, 2L, 3L);
    }

    @Test
    public void limit() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        PrimitiveLongIterator limited = PrimitiveLongCollections.limit((PrimitiveLongIterator)items, (int)2);
        this.assertItems(limited, 1L, 2L);
    }

    @Test
    public void skip() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L, 4L});
        PrimitiveLongIterator skipped = PrimitiveLongCollections.skip((PrimitiveLongIterator)items, (int)2);
        this.assertItems(skipped, 3L, 4L);
    }

    @Test
    public void range() throws Exception {
        PrimitiveLongIterator range = PrimitiveLongCollections.range((long)5L, (long)15L, (long)3L);
        this.assertItems(range, 5L, 8L, 11L, 14L);
    }

    @Test
    public void singleton() throws Exception {
        long item = 15L;
        PrimitiveLongIterator singleton = PrimitiveLongCollections.singleton((long)item);
        this.assertItems(singleton, item);
    }

    @Test
    public void reversed() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        PrimitiveLongIterator reversed = PrimitiveLongCollections.reversed((PrimitiveLongIterator)items);
        this.assertItems(reversed, 3L, 2L, 1L);
    }

    @Test
    public void first() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L});
        try {
            PrimitiveLongCollections.first((PrimitiveLongIterator)PrimitiveLongCollections.emptyIterator());
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        long first = PrimitiveLongCollections.first((PrimitiveLongIterator)items);
        Assert.assertEquals((long)1L, (long)first);
    }

    @Test
    public void firstWithDefault() throws Exception {
        long defaultValue = 5L;
        long firstOnEmpty = PrimitiveLongCollections.first((PrimitiveLongIterator)PrimitiveLongCollections.emptyIterator(), (long)defaultValue);
        long first = PrimitiveLongCollections.first((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L}), (long)defaultValue);
        Assert.assertEquals((long)defaultValue, (long)firstOnEmpty);
        Assert.assertEquals((long)1L, (long)first);
    }

    @Test
    public void last() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L});
        try {
            PrimitiveLongCollections.last((PrimitiveLongIterator)PrimitiveLongCollections.emptyIterator());
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        long last = PrimitiveLongCollections.last((PrimitiveLongIterator)items);
        Assert.assertEquals((long)2L, (long)last);
    }

    @Test
    public void lastWithDefault() throws Exception {
        long defaultValue = 5L;
        long lastOnEmpty = PrimitiveLongCollections.last((PrimitiveLongIterator)PrimitiveLongCollections.emptyIterator(), (long)defaultValue);
        long last = PrimitiveLongCollections.last((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L}), (long)defaultValue);
        Assert.assertEquals((long)defaultValue, (long)lastOnEmpty);
        Assert.assertEquals((long)2L, (long)last);
    }

    @Test
    public void single() throws Exception {
        try {
            PrimitiveLongCollections.single((PrimitiveLongIterator)PrimitiveLongCollections.emptyIterator());
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No"));
        }
        Assert.assertEquals((long)3L, (long)PrimitiveLongCollections.single((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{3L})));
        try {
            PrimitiveLongCollections.single((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L}));
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"More than one"));
        }
    }

    @Test
    public void singleWithDefault() throws Exception {
        Assert.assertEquals((long)5L, (long)PrimitiveLongCollections.single((PrimitiveLongIterator)PrimitiveLongCollections.emptyIterator(), (long)5L));
        Assert.assertEquals((long)3L, (long)PrimitiveLongCollections.single((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{3L})));
        try {
            PrimitiveLongCollections.single((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L}));
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"More than one"));
        }
    }

    @Test
    public void singleMustAutoCloseIterator() {
        AtomicInteger counter = new AtomicInteger();
        CountingPrimitiveLongIteratorResource itr = new CountingPrimitiveLongIteratorResource(PrimitiveLongCollections.iterator((long[])new long[]{13L}), counter);
        Assert.assertEquals((long)PrimitiveLongCollections.single((PrimitiveLongIterator)itr), (long)13L);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void singleWithDefaultMustAutoCloseIterator() {
        AtomicInteger counter = new AtomicInteger();
        CountingPrimitiveLongIteratorResource itr = new CountingPrimitiveLongIteratorResource(PrimitiveLongCollections.iterator((long[])new long[]{13L}), counter);
        Assert.assertEquals((long)PrimitiveLongCollections.single((PrimitiveLongIterator)itr, (long)2L), (long)13L);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void singleMustAutoCloseEmptyIterator() {
        AtomicInteger counter = new AtomicInteger();
        CountingPrimitiveLongIteratorResource itr = new CountingPrimitiveLongIteratorResource(PrimitiveLongCollections.emptyIterator(), counter);
        try {
            PrimitiveLongCollections.single((PrimitiveLongIterator)itr);
            Assert.fail((String)"single() on empty iterator should have thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void singleWithDefaultMustAutoCloseEmptyIterator() {
        AtomicInteger counter = new AtomicInteger();
        CountingPrimitiveLongIteratorResource itr = new CountingPrimitiveLongIteratorResource(PrimitiveLongCollections.emptyIterator(), counter);
        Assert.assertEquals((long)PrimitiveLongCollections.single((PrimitiveLongIterator)itr, (long)2L), (long)2L);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void itemAt() throws Exception {
        PrimitiveLongIterable items = () -> PrimitiveLongCollections.iterator((long[])new long[]{10L, 20L, 30L});
        try {
            PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)3);
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No element"));
        }
        try {
            PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)-4);
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"not found"));
        }
        Assert.assertEquals((long)10L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)0));
        Assert.assertEquals((long)20L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)1));
        Assert.assertEquals((long)30L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)2));
        Assert.assertEquals((long)30L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)-1));
        Assert.assertEquals((long)20L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)-2));
        Assert.assertEquals((long)10L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)-3));
    }

    @Test
    public void itemAtWithDefault() throws Exception {
        PrimitiveLongIterable items = () -> PrimitiveLongCollections.iterator((long[])new long[]{10L, 20L, 30L});
        long defaultValue = 55L;
        Assert.assertEquals((long)defaultValue, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)3, (long)defaultValue));
        Assert.assertEquals((long)defaultValue, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)-4, (long)defaultValue));
        Assert.assertEquals((long)10L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)0));
        Assert.assertEquals((long)20L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)1));
        Assert.assertEquals((long)30L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)2));
        Assert.assertEquals((long)30L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)-1));
        Assert.assertEquals((long)20L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)-2));
        Assert.assertEquals((long)10L, (long)PrimitiveLongCollections.itemAt((PrimitiveLongIterator)items.iterator(), (int)-3));
    }

    @Test
    public void indexOf() throws Exception {
        PrimitiveLongIterable items = () -> PrimitiveLongCollections.iterator((long[])new long[]{10L, 20L, 30L});
        Assert.assertEquals((long)-1L, (long)PrimitiveLongCollections.indexOf((PrimitiveLongIterator)items.iterator(), (long)55L));
        Assert.assertEquals((long)0L, (long)PrimitiveLongCollections.indexOf((PrimitiveLongIterator)items.iterator(), (long)10L));
        Assert.assertEquals((long)1L, (long)PrimitiveLongCollections.indexOf((PrimitiveLongIterator)items.iterator(), (long)20L));
        Assert.assertEquals((long)2L, (long)PrimitiveLongCollections.indexOf((PrimitiveLongIterator)items.iterator(), (long)30L));
    }

    @Test
    public void iteratorsEqual() throws Exception {
        PrimitiveLongIterable items1 = () -> PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        PrimitiveLongIterable items2 = () -> PrimitiveLongCollections.iterator((long[])new long[]{1L, 20L, 3L});
        PrimitiveLongIterable items3 = () -> PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L, 4L});
        PrimitiveLongIterable items4 = () -> PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        Assert.assertFalse((boolean)PrimitiveLongCollections.equals((PrimitiveLongIterator)items1.iterator(), (PrimitiveLongIterator)items2.iterator()));
        Assert.assertFalse((boolean)PrimitiveLongCollections.equals((PrimitiveLongIterator)items1.iterator(), (PrimitiveLongIterator)items3.iterator()));
        Assert.assertTrue((boolean)PrimitiveLongCollections.equals((PrimitiveLongIterator)items1.iterator(), (PrimitiveLongIterator)items4.iterator()));
    }

    @Test
    public void iteratorAsSet() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        PrimitiveLongSet set = PrimitiveLongCollections.asSet((PrimitiveLongIterator)items);
        Assert.assertTrue((boolean)set.contains(1L));
        Assert.assertTrue((boolean)set.contains(2L));
        Assert.assertTrue((boolean)set.contains(3L));
        Assert.assertFalse((boolean)set.contains(4L));
        try {
            PrimitiveLongCollections.asSet((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 1L}));
            Assert.fail((String)"Should fail on duplicates");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void iteratorAsSetAllowDuplicates() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 1L});
        PrimitiveLongSet set = PrimitiveLongCollections.asSetAllowDuplicates((PrimitiveLongIterator)items);
        Assert.assertTrue((boolean)set.contains(1L));
        Assert.assertTrue((boolean)set.contains(2L));
        Assert.assertFalse((boolean)set.contains(3L));
    }

    @Test
    public void count() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        int count = PrimitiveLongCollections.count((PrimitiveLongIterator)items);
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void asArray() throws Exception {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        long[] array = PrimitiveLongCollections.asArray((PrimitiveLongIterator)items);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L, 3L}, array));
    }

    @Test
    public void shouldDeduplicate() throws Exception {
        long[] array = new long[]{1L, 1L, 2L, 5L, 6L, 6L};
        long[] deduped = PrimitiveLongCollections.deduplicate((long[])array);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 5L, 6L}, (long[])deduped);
    }

    @Test
    public void shouldNotContinueToCallNextOnHasNextFalse() throws Exception {
        final AtomicLong count = new AtomicLong(2L);
        PrimitiveLongCollections.PrimitiveLongBaseIterator iterator = new PrimitiveLongCollections.PrimitiveLongBaseIterator(){

            protected boolean fetchNext() {
                return count.decrementAndGet() >= 0L && this.next(count.get());
            }
        };
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)0L, (long)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)-1L, (long)count.get());
    }

    private void assertNoMoreItems(PrimitiveLongIterator iterator) {
        Assert.assertFalse((String)(iterator + " should have no more items"), (boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)("Invoking next() on " + iterator + " which has no items left should have thrown NoSuchElementException"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void assertNextEquals(long expected, PrimitiveLongIterator iterator) {
        Assert.assertTrue((String)(iterator + " should have had more items"), (boolean)iterator.hasNext());
        Assert.assertEquals((long)expected, (long)iterator.next());
    }

    private void assertItems(PrimitiveLongIterator iterator, long ... expectedItems) {
        for (long expectedItem : expectedItems) {
            this.assertNextEquals(expectedItem, iterator);
        }
        this.assertNoMoreItems(iterator);
    }

    private long[] reverse(long[] items) {
        long[] result = new long[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = items[items.length - i - 1];
        }
        return result;
    }

    private static final class CountingPrimitiveLongIteratorResource
    implements PrimitiveLongIterator,
    AutoCloseable {
        private final PrimitiveLongIterator delegate;
        private final AtomicInteger closeCounter;

        private CountingPrimitiveLongIteratorResource(PrimitiveLongIterator delegate, AtomicInteger closeCounter) {
            this.delegate = delegate;
            this.closeCounter = closeCounter;
        }

        @Override
        public void close() throws Exception {
            this.closeCounter.incrementAndGet();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public long next() {
            return this.delegate.next();
        }
    }
}

