/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.pool;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.pool.MarshlandPool;
import org.neo4j.collection.pool.Pool;

public class MarshlandPoolTest {
    @Test
    public void shouldNotLooseObjectsWhenThreadsDie() throws Exception {
        Pool delegatePool = (Pool)Mockito.mock(Pool.class);
        Mockito.when((Object)delegatePool.acquire()).thenReturn((Object)1337, new Object[]{-1});
        MarshlandPool pool = new MarshlandPool(delegatePool);
        this.claimAndReleaseInSeparateThread((MarshlandPool<Object>)pool);
        ((Pool)Mockito.verify((Object)delegatePool)).acquire();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegatePool});
        this.assertPoolEventuallyReturns((Pool<Object>)pool, 1337);
    }

    @Test
    public void shouldReturnToDelegatePoolIfLocalPoolIsFull() throws Exception {
        Pool delegatePool = (Pool)Mockito.mock(Pool.class);
        Mockito.when((Object)delegatePool.acquire()).thenReturn((Object)1337);
        MarshlandPool pool = new MarshlandPool(delegatePool);
        Object first = pool.acquire();
        Object second = pool.acquire();
        Object third = pool.acquire();
        pool.release(first);
        pool.release(second);
        pool.release(third);
        ((Pool)Mockito.verify((Object)delegatePool, (VerificationMode)Mockito.times((int)3))).acquire();
        ((Pool)Mockito.verify((Object)delegatePool, (VerificationMode)Mockito.times((int)2))).release(Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegatePool});
    }

    @Test
    public void shouldReleaseAllSlotsOnClose() throws Exception {
        Pool delegatePool = (Pool)Mockito.mock(Pool.class);
        Mockito.when((Object)delegatePool.acquire()).thenReturn((Object)1337);
        MarshlandPool pool = new MarshlandPool(delegatePool);
        Object first = pool.acquire();
        pool.release(first);
        pool.close();
        ((Pool)Mockito.verify((Object)delegatePool, (VerificationMode)Mockito.times((int)1))).acquire();
        ((Pool)Mockito.verify((Object)delegatePool, (VerificationMode)Mockito.times((int)1))).release(Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegatePool});
    }

    private void assertPoolEventuallyReturns(Pool<Object> pool, int expected) throws InterruptedException {
        long maxTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        while (System.currentTimeMillis() < maxTime) {
            if (!pool.acquire().equals(expected)) continue;
            return;
        }
        Assert.fail((String)"Waited 10 seconds for pool to return object from dead thread, but it was never returned.");
    }

    private void claimAndReleaseInSeparateThread(MarshlandPool<Object> pool) throws InterruptedException {
        Thread thread = new Thread(() -> {
            Object obj = pool.acquire();
            pool.release(obj);
        });
        thread.start();
        thread.join();
    }
}

