/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.LongToIntFunction;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveCommons;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.base.Empty;

public class PrimitiveIntCollections {
    private static final PrimitiveIntIterator EMPTY = new PrimitiveIntBaseIterator(){

        @Override
        protected boolean fetchNext() {
            return false;
        }
    };

    private PrimitiveIntCollections() {
    }

    public static PrimitiveIntIterator iterator(final int ... items) {
        return new PrimitiveIntBaseIterator(){
            private int index = -1;

            @Override
            protected boolean fetchNext() {
                return ++this.index < items.length && this.next(items[this.index]);
            }
        };
    }

    public static PrimitiveIntIterator reversed(final int ... items) {
        return new PrimitiveIntBaseIterator(){
            private int index;
            {
                this.index = items.length;
            }

            @Override
            protected boolean fetchNext() {
                return --this.index >= 0 && this.next(items[this.index]);
            }
        };
    }

    public static PrimitiveIntIterator reversed(PrimitiveIntIterator source) {
        int[] items = PrimitiveIntCollections.asArray(source);
        return PrimitiveIntCollections.reversed(items);
    }

    public static PrimitiveIntIterator concat(Iterator<PrimitiveIntIterator> iterators) {
        return new PrimitiveIntConcatingIterator(iterators);
    }

    public static PrimitiveIntIterator prepend(final int item, final PrimitiveIntIterator iterator) {
        return new PrimitiveIntBaseIterator(){
            private boolean singleItemReturned;

            @Override
            protected boolean fetchNext() {
                if (!this.singleItemReturned) {
                    this.singleItemReturned = true;
                    return this.next(item);
                }
                return iterator.hasNext() && this.next(iterator.next());
            }
        };
    }

    public static PrimitiveIntIterator append(final PrimitiveIntIterator iterator, final int item) {
        return new PrimitiveIntBaseIterator(){
            private boolean singleItemReturned;

            @Override
            protected boolean fetchNext() {
                if (iterator.hasNext()) {
                    return this.next(iterator.next());
                }
                if (!this.singleItemReturned) {
                    this.singleItemReturned = true;
                    return this.next(item);
                }
                return false;
            }
        };
    }

    public static PrimitiveIntIterator filter(PrimitiveIntIterator source, final IntPredicate filter) {
        return new PrimitiveIntFilteringIterator(source){

            @Override
            public boolean test(int item) {
                return filter.test(item);
            }
        };
    }

    public static PrimitiveIntIterator deduplicate(PrimitiveIntIterator source) {
        return new PrimitiveIntFilteringIterator(source){
            private final PrimitiveIntSet visited = Primitive.intSet();

            @Override
            public boolean test(int testItem) {
                return this.visited.add(testItem);
            }
        };
    }

    public static PrimitiveIntIterator not(PrimitiveIntIterator source, final int disallowedValue) {
        return new PrimitiveIntFilteringIterator(source){

            @Override
            public boolean test(int testItem) {
                return testItem != disallowedValue;
            }
        };
    }

    public static PrimitiveIntIterator skip(PrimitiveIntIterator source, final int skipTheFirstNItems) {
        return new PrimitiveIntFilteringIterator(source){
            private int skipped;

            @Override
            public boolean test(int item) {
                if (this.skipped < skipTheFirstNItems) {
                    ++this.skipped;
                    return false;
                }
                return true;
            }
        };
    }

    public static PrimitiveIntIterator limit(final PrimitiveIntIterator source, final int maxItems) {
        return new PrimitiveIntBaseIterator(){
            private int visited;

            @Override
            protected boolean fetchNext() {
                if (this.visited++ < maxItems && source.hasNext()) {
                    return this.next(source.next());
                }
                return false;
            }
        };
    }

    public static PrimitiveIntIterator range(int end) {
        return PrimitiveIntCollections.range(0, end);
    }

    public static PrimitiveIntIterator range(int start, int end) {
        return PrimitiveIntCollections.range(start, end, 1);
    }

    public static PrimitiveIntIterator range(int start, int end, int stride) {
        return new PrimitiveIntRangeIterator(start, end, stride);
    }

    public static PrimitiveIntIterator singleton(final int item) {
        return new PrimitiveIntBaseIterator(){
            private boolean returned;

            @Override
            protected boolean fetchNext() {
                try {
                    boolean bl = !this.returned && this.next(item);
                    return bl;
                }
                finally {
                    this.returned = true;
                }
            }
        };
    }

    public static int first(PrimitiveIntIterator iterator) {
        PrimitiveIntCollections.assertMoreItems(iterator);
        return iterator.next();
    }

    private static void assertMoreItems(PrimitiveIntIterator iterator) {
        if (!iterator.hasNext()) {
            throw new NoSuchElementException("No element in " + iterator);
        }
    }

    public static int first(PrimitiveIntIterator iterator, int defaultItem) {
        return iterator.hasNext() ? iterator.next() : defaultItem;
    }

    public static int last(PrimitiveIntIterator iterator) {
        PrimitiveIntCollections.assertMoreItems(iterator);
        return PrimitiveIntCollections.last(iterator, 0);
    }

    public static int last(PrimitiveIntIterator iterator, int defaultItem) {
        int result = defaultItem;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static int single(PrimitiveIntIterator iterator) {
        try {
            PrimitiveIntCollections.assertMoreItems(iterator);
            int item = iterator.next();
            if (iterator.hasNext()) {
                throw new NoSuchElementException("More than one item in " + iterator + ", first:" + item + ", second:" + iterator.next());
            }
            PrimitiveCommons.closeSafely(iterator);
            return item;
        }
        catch (NoSuchElementException exception) {
            PrimitiveCommons.closeSafely(iterator, exception);
            throw exception;
        }
    }

    public static int single(PrimitiveIntIterator iterator, int defaultItem) {
        try {
            if (!iterator.hasNext()) {
                PrimitiveCommons.closeSafely(iterator);
                return defaultItem;
            }
            int item = iterator.next();
            if (iterator.hasNext()) {
                throw new NoSuchElementException("More than one item in " + iterator + ", first:" + item + ", second:" + iterator.next());
            }
            PrimitiveCommons.closeSafely(iterator);
            return item;
        }
        catch (NoSuchElementException exception) {
            PrimitiveCommons.closeSafely(iterator, exception);
            throw exception;
        }
    }

    public static int itemAt(PrimitiveIntIterator iterator, int index) {
        if (index >= 0) {
            for (int i = 0; iterator.hasNext() && i < index; ++i) {
                iterator.next();
            }
            PrimitiveIntCollections.assertMoreItems(iterator);
            return iterator.next();
        }
        int fromEnd = index * -1;
        int[] trail = new int[fromEnd];
        int cursor = 0;
        while (iterator.hasNext()) {
            trail[cursor % trail.length] = iterator.next();
            ++cursor;
        }
        if (cursor < fromEnd) {
            throw new NoSuchElementException("Item " + index + " not found in " + iterator);
        }
        return trail[cursor % fromEnd];
    }

    public static int itemAt(PrimitiveIntIterator iterator, int index, int defaultItem) {
        if (index >= 0) {
            for (int i = 0; iterator.hasNext() && i < index; ++i) {
                iterator.next();
            }
            return iterator.hasNext() ? iterator.next() : defaultItem;
        }
        int fromEnd = index * -1;
        int[] trail = new int[fromEnd];
        int cursor = 0;
        while (iterator.hasNext()) {
            trail[cursor % trail.length] = iterator.next();
            ++cursor;
        }
        return cursor < fromEnd ? defaultItem : trail[cursor % fromEnd];
    }

    public static int indexOf(PrimitiveIntIterator iterator, int item) {
        int i = 0;
        while (iterator.hasNext()) {
            if (item == iterator.next()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean equals(PrimitiveIntIterator first, PrimitiveIntIterator other) {
        boolean otherHasNext;
        boolean firstHasNext;
        while ((firstHasNext = first.hasNext()) | (otherHasNext = other.hasNext())) {
            if (firstHasNext == otherHasNext && first.next() == other.next()) continue;
            return false;
        }
        return true;
    }

    public static PrimitiveIntSet asSet(PrimitiveIntIterator iterator) {
        PrimitiveIntSet set = Primitive.intSet();
        while (iterator.hasNext()) {
            int next = iterator.next();
            if (set.add(next)) continue;
            throw new IllegalStateException("Duplicate " + next + " from " + iterator);
        }
        return set;
    }

    public static PrimitiveIntSet asSetAllowDuplicates(PrimitiveIntIterator iterator) {
        PrimitiveIntSet set = Primitive.intSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static int count(PrimitiveIntIterator iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static int[] asArray(PrimitiveIntIterator iterator) {
        int[] array = new int[8];
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= array.length) {
                array = Arrays.copyOf(array, i << 1);
            }
            array[i] = iterator.next();
            ++i;
        }
        if (i < array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    public static int[] asArray(Collection<Integer> values) {
        int[] array = new int[values.size()];
        int i = 0;
        for (int value : values) {
            array[i++] = value;
        }
        return array;
    }

    public static PrimitiveIntIterator emptyIterator() {
        return EMPTY;
    }

    public static PrimitiveIntSet emptySet() {
        return Empty.EMPTY_PRIMITIVE_INT_SET;
    }

    public static PrimitiveIntIterator toPrimitiveIterator(final Iterator<Integer> iterator) {
        return new PrimitiveIntBaseIterator(){

            @Override
            protected boolean fetchNext() {
                if (iterator.hasNext()) {
                    Integer nextValue = (Integer)iterator.next();
                    if (null == nextValue) {
                        throw new IllegalArgumentException("Cannot convert null Integer to primitive int");
                    }
                    return this.next(nextValue);
                }
                return false;
            }
        };
    }

    public static PrimitiveIntIterator flatten(final Iterator<PrimitiveIntIterator> source) {
        return new PrimitiveIntBaseIterator(){
            private PrimitiveIntIterator current;

            @Override
            protected boolean fetchNext() {
                while (this.current == null || !this.current.hasNext()) {
                    if (!source.hasNext()) {
                        return false;
                    }
                    this.current = (PrimitiveIntIterator)source.next();
                }
                return source.hasNext() && this.next(this.current.next());
            }
        };
    }

    public static <T> Iterator<T> map(final IntFunction<T> mapFunction, final PrimitiveIntIterator source) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                return mapFunction.apply(source.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static void consume(PrimitiveIntIterator source, IntConsumer consumer) {
        while (source.hasNext()) {
            consumer.accept(source.next());
        }
    }

    public static PrimitiveIntIterator constant(final int value) {
        return new PrimitiveIntBaseIterator(){

            @Override
            protected boolean fetchNext() {
                return this.next(value);
            }
        };
    }

    public static PrimitiveIntSet asSet(int[] values) {
        PrimitiveIntSet set = Primitive.intSet(values.length);
        for (int value : values) {
            set.add(value);
        }
        return set;
    }

    public static PrimitiveIntSet asSet(long[] values, LongToIntFunction converter) {
        PrimitiveIntSet set = Primitive.intSet(values.length);
        for (long value : values) {
            set.add(converter.applyAsInt(value));
        }
        return set;
    }

    public static boolean contains(int[] values, int candidate) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != candidate) continue;
            return true;
        }
        return false;
    }

    public static List<Integer> toList(PrimitiveIntIterator iterator) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
        return out;
    }

    public static Set<Integer> toSet(PrimitiveIntIterator iterator) {
        return PrimitiveIntCollections.mapToSet(iterator, Integer::new);
    }

    public static <T> Set<T> mapToSet(PrimitiveIntIterator iterator, IntFunction<T> map) {
        HashSet set = new HashSet();
        while (iterator.hasNext()) {
            PrimitiveIntCollections.addUnique(set, map.apply(iterator.next()));
        }
        return set;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static int[] deduplicate(int[] values) {
        int unique = 0;
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            for (int j = 0; j < unique; ++j) {
                if (value != values[j]) continue;
                value = -1;
                break;
            }
            if (value == -1) continue;
            values[unique++] = values[i];
        }
        return unique < values.length ? Arrays.copyOf(values, unique) : values;
    }

    public static class PrimitiveIntRangeIterator
    extends PrimitiveIntBaseIterator {
        private int current;
        private final int end;
        private final int stride;

        public PrimitiveIntRangeIterator(int start, int end, int stride) {
            this.current = start;
            this.end = end;
            this.stride = stride;
        }

        @Override
        protected boolean fetchNext() {
            try {
                boolean bl = this.current <= this.end && this.next(this.current);
                return bl;
            }
            finally {
                this.current += this.stride;
            }
        }
    }

    public static abstract class PrimitiveIntFilteringIterator
    extends PrimitiveIntBaseIterator
    implements IntPredicate {
        private final PrimitiveIntIterator source;

        public PrimitiveIntFilteringIterator(PrimitiveIntIterator source) {
            this.source = source;
        }

        @Override
        protected boolean fetchNext() {
            while (this.source.hasNext()) {
                int testItem = this.source.next();
                if (!this.test(testItem)) continue;
                return this.next(testItem);
            }
            return false;
        }

        @Override
        public abstract boolean test(int var1);
    }

    public static class PrimitiveIntInterleavingIterator
    extends PrimitiveIntBaseIterator {
        private final Iterable<PrimitiveIntIterator> iterators;
        private Iterator<PrimitiveIntIterator> currentRound;

        public PrimitiveIntInterleavingIterator(Iterable<PrimitiveIntIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentRound == null || !this.currentRound.hasNext()) {
                this.currentRound = this.iterators.iterator();
            }
            while (this.currentRound.hasNext()) {
                PrimitiveIntIterator iterator = this.currentRound.next();
                if (!iterator.hasNext()) continue;
                return this.next(iterator.next());
            }
            this.currentRound = null;
            return false;
        }
    }

    public static class PrimitiveIntConcatingIterator
    extends PrimitiveIntBaseIterator {
        private final Iterator<PrimitiveIntIterator> iterators;
        private PrimitiveIntIterator currentIterator;

        public PrimitiveIntConcatingIterator(Iterator<PrimitiveIntIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                while (this.iterators.hasNext()) {
                    this.currentIterator = this.iterators.next();
                    if (!this.currentIterator.hasNext()) continue;
                }
            }
            return this.currentIterator != null && this.currentIterator.hasNext() && this.next(this.currentIterator.next());
        }

        protected final PrimitiveIntIterator currentIterator() {
            return this.currentIterator;
        }
    }

    public static abstract class PrimitiveIntBaseIterator
    implements PrimitiveIntIterator {
        private boolean hasNextDecided;
        private boolean hasNext;
        private int next;

        @Override
        public boolean hasNext() {
            if (!this.hasNextDecided) {
                this.hasNext = this.fetchNext();
                this.hasNextDecided = true;
            }
            return this.hasNext;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in " + this);
            }
            this.hasNextDecided = false;
            return this.next;
        }

        protected abstract boolean fetchNext();

        protected boolean next(int nextItem) {
            this.next = nextItem;
            this.hasNext = true;
            return true;
        }
    }
}

