/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.test.randomized.Action;
import org.neo4j.test.randomized.LinePrinter;
import org.neo4j.test.randomized.Printable;
import org.neo4j.test.randomized.RandomizedTester;
import org.neo4j.test.randomized.Result;
import org.neo4j.test.randomized.TestResource;

public class PrimitiveLongObjectMapRIT {
    @Test
    public void thoroughlyTestIt() throws Exception {
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        while (System.currentTimeMillis() < endTime) {
            long seed = System.currentTimeMillis();
            Random random = new Random(seed);
            int max = random.nextInt(10000) + 100;
            RandomizedTester<Maps, String> actions = new RandomizedTester<Maps, String>(this.mapFactory(), this.actionFactory(random));
            Result<Maps, String> result = actions.run(max);
            if (result.isFailure()) {
                System.out.println("Found failure at " + result);
                actions.testCaseWriter("shouldOnlyContainAddedValues", this.given()).print(System.out);
                System.out.println("Actually, minimal reproducible test of that is...");
                actions.findMinimalReproducible().testCaseWriter("shouldOnlyContainAddedValues", this.given()).print(System.out);
                Assert.fail((String)("Failed, see printed test case for how to reproduce. Seed:" + seed));
            }
            this.fullVerification(result.getTarget(), random);
        }
    }

    private void fullVerification(Maps target, Random random) {
        for (Map.Entry<Long, Integer> entry : target.normalMap.entrySet()) {
            Assert.assertTrue((boolean)target.map.containsKey(entry.getKey().longValue()));
            Assert.assertEquals((Object)entry.getValue(), (Object)target.map.get(entry.getKey().longValue()));
        }
        for (int i = 0; i < target.normalMap.size(); ++i) {
            Assert.assertFalse((boolean)target.map.containsKey(this.randomNonExisting(random, target.normalMap)));
        }
    }

    private Printable given() {
        return out -> out.println(PrimitiveLongObjectMap.class.getSimpleName() + "<Integer> map = " + Primitive.class.getSimpleName() + ".longObjectMap();");
    }

    private RandomizedTester.ActionFactory<Maps, String> actionFactory(Random random) {
        return from -> this.generateAction(random, (Maps)from);
    }

    private RandomizedTester.TargetFactory<Maps> mapFactory() {
        return () -> new Maps();
    }

    protected Action<Maps, String> generateAction(Random random, Maps from) {
        boolean anExisting = !from.normalMap.isEmpty() && random.nextInt(3) == 0;
        long key = anExisting ? this.randomExisting(random, from.normalMap) : this.randomNonExisting(random, from.normalMap);
        Integer value = random.nextInt(100);
        int typeOfAction = random.nextInt(5);
        if (typeOfAction == 0) {
            return new RemoveAction(key);
        }
        return new AddAction(key, value);
    }

    private long randomNonExisting(Random random, Map<Long, Integer> existing) {
        long key;
        while (existing.containsKey(key = Math.abs(random.nextLong()))) {
        }
        return key;
    }

    private long randomExisting(Random random, Map<Long, Integer> existing) {
        int index = random.nextInt(existing.size()) + 1;
        Iterator<Long> iterator = existing.keySet().iterator();
        long value = 0L;
        for (int i = 0; i < index; ++i) {
            value = iterator.next();
        }
        return value;
    }

    private static String capitilize(boolean bool) {
        String string = Boolean.valueOf(bool).toString();
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    private static class Maps
    implements TestResource {
        final Map<Long, Integer> normalMap = new HashMap<Long, Integer>();
        final PrimitiveLongObjectMap<Integer> map = Primitive.longObjectMap();

        private Maps() {
        }

        public String toString() {
            return this.map.toString();
        }

        @Override
        public void close() {
        }
    }

    private static class RemoveAction
    implements Action<Maps, String> {
        private final long key;

        RemoveAction(long key) {
            this.key = key;
        }

        @Override
        public String apply(Maps target) {
            Integer existingValue = target.normalMap.get(this.key);
            boolean existedBefore = target.map.containsKey(this.key);
            Integer valueBefore = (Integer)target.map.get(this.key);
            Integer removed = (Integer)target.map.remove(this.key);
            boolean existsAfter = target.map.containsKey(this.key);
            Integer valueAfter = (Integer)target.map.get(this.key);
            target.normalMap.remove(this.key);
            boolean existing = existingValue != null;
            boolean ok = existedBefore == existing & (existing ? valueBefore.equals(existingValue) : valueBefore == null) & (existing ? removed.equals(existingValue) : removed == null) & valueAfter == null & !existsAfter;
            return ok ? null : "" + this.key + "," + existingValue + "," + existedBefore + "," + removed + "," + existsAfter;
        }

        @Override
        public void printAsCode(Maps source, LinePrinter out, boolean includeChecks) {
            Integer existingValue = source.normalMap.get(this.key);
            String removal = "map.remove( " + this.key + " );";
            if (includeChecks) {
                boolean existing = existingValue != null;
                out.println(String.format("boolean existedBefore = map.containsKey( %d );", this.key));
                out.println(String.format("Integer valueBefore = map.get( %d );", this.key));
                out.println(String.format("Integer removed = %s", removal));
                out.println(String.format("boolean existsAfter = map.containsKey( %d );", this.key));
                out.println(String.format("Integer valueAfter = map.get( %d );", this.key));
                out.println(String.format("assert%s( \"%s\", existedBefore );", PrimitiveLongObjectMapRIT.capitilize(existing), this.key + " should " + (existing ? "" : "not ") + "exist before putting here"));
                if (existing) {
                    out.println(String.format("assertEquals( \"%s\", (Integer)%d, valueBefore );", "value before should be " + existingValue, existingValue));
                    out.println(String.format("assertEquals( \"%s\", (Integer)%d, removed );", "value returned from put should be " + existingValue, existingValue));
                } else {
                    out.println(String.format("assertNull( \"%s\", valueBefore );", "value before putting should be null"));
                    out.println(String.format("assertNull( \"%s\", removed );", "value returned from putting should be null"));
                }
                out.println(String.format("assertFalse( \"%s\", existsAfter );", this.key + " should not exist"));
                out.println(String.format("assertNull( \"%s\", valueAfter );", "value after removing should be null"));
            } else {
                out.println(removal);
            }
        }
    }

    private static class AddAction
    implements Action<Maps, String> {
        private final long key;
        private final Integer value;

        AddAction(long key, Integer value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String apply(Maps target) {
            Integer existingValue = target.normalMap.get(this.key);
            int actualSizeBefore = target.normalMap.size();
            int sizeBefore = target.map.size();
            boolean existedBefore = target.map.containsKey(this.key);
            Integer valueBefore = (Integer)target.map.get(this.key);
            Integer previous = (Integer)target.map.put(this.key, (Object)this.value);
            boolean existsAfter = target.map.containsKey(this.key);
            Integer valueAfter = (Integer)target.map.get(this.key);
            target.normalMap.put(this.key, this.value);
            int sizeAfter = target.map.size();
            int actualSizeAfter = target.normalMap.size();
            boolean existing = existingValue != null;
            boolean ok = sizeBefore == actualSizeBefore & existedBefore == existing & (existing ? existingValue.equals(valueBefore) : valueBefore == null) & (existing ? previous.equals(existingValue) : previous == null) & (valueAfter != null && valueAfter.equals(this.value)) & existsAfter & sizeAfter == actualSizeAfter;
            return ok ? null : "" + this.key + ":" + this.value + "," + existingValue + "," + existedBefore + "," + previous + "," + existsAfter;
        }

        @Override
        public void printAsCode(Maps source, LinePrinter out, boolean includeChecks) {
            Integer existingValue = source.normalMap.get(this.key);
            String addition = "map.put( " + this.key + ", " + this.value + " );";
            if (includeChecks) {
                boolean existing = existingValue != null;
                out.println(String.format("int sizeBefore = map.size();", new Object[0]));
                out.println(String.format("boolean existedBefore = map.containsKey( %d );", this.key));
                out.println(String.format("Integer valueBefore = map.get( %d );", this.key));
                out.println(String.format("Integer previous = %s", addition));
                out.println(String.format("boolean existsAfter = map.containsKey( %d );", this.key));
                out.println(String.format("Integer valueAfter = map.get( %d );", this.key));
                out.println(String.format("int sizeAfter = map.size();", new Object[0]));
                int actualSizeBefore = source.normalMap.size();
                out.println(String.format("assertEquals( \"%s\", %d, sizeBefore );", "Size before put should have been " + actualSizeBefore, actualSizeBefore));
                out.println(String.format("assert%s( \"%s\", existedBefore );", PrimitiveLongObjectMapRIT.capitilize(existing), this.key + " should " + (existing ? "" : "not ") + "exist before putting here"));
                if (existing) {
                    out.println(String.format("assertEquals( \"%s\", (Integer)%d, valueBefore );", "value before should be " + existingValue, existingValue));
                    out.println(String.format("assertEquals( \"%s\", (Integer)%d, previous );", "value returned from put should be " + existingValue, existingValue));
                } else {
                    out.println(String.format("assertNull( \"%s\", valueBefore );", "value before putting should be null"));
                    out.println(String.format("assertNull( \"%s\", previous );", "value returned from putting should be null"));
                }
                out.println(String.format("assertTrue( \"%s\", existsAfter );", this.key + " should exist"));
                out.println(String.format("assertEquals( \"%s\", (Integer)%d, valueAfter );", "value after putting should be " + this.value, this.value));
                int actualSizeAfter = existing ? actualSizeBefore : actualSizeBefore + 1;
                out.println(String.format("assertEquals( \"%s\", %d, sizeAfter );", "Size after put should have been " + actualSizeAfter, actualSizeAfter));
            } else {
                out.println(addition);
            }
        }
    }
}

