/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.hopscotch.IntKeyTable;
import org.neo4j.collection.primitive.hopscotch.IntKeyUnsafeTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyIntValueTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyLongValueUnsafeTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyObjectValueTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyTable;
import org.neo4j.collection.primitive.hopscotch.LongKeyUnsafeTable;
import org.neo4j.collection.primitive.hopscotch.Table;

@RunWith(value=Parameterized.class)
public class BasicTableTest {
    private final TableFactory factory;
    private static final long seed = System.currentTimeMillis();
    private static final Random random = new Random(seed);

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        result.add(new Object[]{new TableFactory(){

            @Override
            public Table newTable(int capacity) {
                return new IntKeyTable(capacity, Primitive.VALUE_MARKER);
            }

            @Override
            public boolean supportsLongs() {
                return false;
            }

            @Override
            public Object sampleValue() {
                return null;
            }
        }});
        result.add(new Object[]{new TableFactory(){

            @Override
            public Table newTable(int capacity) {
                return new LongKeyTable(capacity, Primitive.VALUE_MARKER);
            }

            @Override
            public boolean supportsLongs() {
                return true;
            }

            @Override
            public Object sampleValue() {
                return null;
            }
        }});
        result.add(new Object[]{new TableFactory(){

            @Override
            public Table newTable(int capacity) {
                return new IntKeyUnsafeTable(capacity, Primitive.VALUE_MARKER);
            }

            @Override
            public boolean supportsLongs() {
                return false;
            }

            @Override
            public Object sampleValue() {
                return null;
            }
        }});
        result.add(new Object[]{new TableFactory(){

            @Override
            public Table newTable(int capacity) {
                return new LongKeyUnsafeTable(capacity, Primitive.VALUE_MARKER);
            }

            @Override
            public boolean supportsLongs() {
                return true;
            }

            @Override
            public Object sampleValue() {
                return null;
            }
        }});
        result.add(new Object[]{new TableFactory(){

            @Override
            public Table newTable(int capacity) {
                return new LongKeyIntValueTable(capacity);
            }

            @Override
            public boolean supportsLongs() {
                return true;
            }

            @Override
            public Object sampleValue() {
                return new int[]{random.nextInt(Integer.MAX_VALUE)};
            }
        }});
        result.add(new Object[]{new TableFactory(){

            @Override
            public Table newTable(int capacity) {
                return new LongKeyObjectValueTable(capacity);
            }

            @Override
            public boolean supportsLongs() {
                return true;
            }

            @Override
            public Object sampleValue() {
                return new long[]{Math.abs(random.nextLong())};
            }
        }});
        result.add(new Object[]{new TableFactory(){

            @Override
            public Table newTable(int capacity) {
                return new LongKeyLongValueUnsafeTable(capacity);
            }

            @Override
            public boolean supportsLongs() {
                return true;
            }

            @Override
            public Object sampleValue() {
                return new long[]{Math.abs(random.nextLong())};
            }
        }});
        return result;
    }

    public BasicTableTest(TableFactory factory) {
        this.factory = factory;
    }

    @Test
    public void shouldSetAndGetSmallKey() throws Exception {
        try (Table table = this.factory.newTable(16);){
            long nullKey = table.nullKey();
            Assert.assertEquals((long)nullKey, (long)table.key(0));
            long key = 12345L;
            int index = 2;
            table.put(index, key, this.factory.sampleValue());
            Assert.assertEquals((long)key, (long)table.key(index));
            table.remove(index);
            Assert.assertEquals((long)nullKey, (long)table.key(index));
        }
    }

    @Test
    public void shouldSetAndGetBigKey() throws Exception {
        Assume.assumeTrue((boolean)this.factory.supportsLongs());
        try (Table table = this.factory.newTable(16);){
            long nullKey = table.nullKey();
            Assert.assertEquals((long)nullKey, (long)table.key(0));
            long key = 9928962815L;
            int index = 2;
            table.put(index, key, this.factory.sampleValue());
            Assert.assertEquals((long)key, (long)table.key(index));
        }
    }

    @Test
    public void shouldRemoveBigKey() throws Exception {
        Assume.assumeTrue((boolean)this.factory.supportsLongs());
        try (Table table = this.factory.newTable(16);){
            long nullKey = table.nullKey();
            long key = 9917428734L;
            int index = 5;
            table.put(index, key, this.factory.sampleValue());
            Assert.assertEquals((long)key, (long)table.key(index));
            table.remove(index);
            Assert.assertEquals((long)nullKey, (long)table.key(index));
        }
    }

    @Test
    public void shouldSetHopBits() throws Exception {
        try (Table table = this.factory.newTable(16);){
            int index = 10;
            long hopBits = table.hopBits(index);
            Assert.assertEquals((long)0L, (long)hopBits);
            table.putHopBit(index, 2);
            table.putHopBit(index, 11);
            Assert.assertEquals((long)2052L, (long)table.hopBits(index));
        }
    }

    @Test
    public void shouldMoveHopBit() throws Exception {
        try (Table table = this.factory.newTable(16);){
            int index = 10;
            table.putHopBit(index, 2);
            table.putHopBit(index, 11);
            table.moveHopBit(index, 2, 15);
            Assert.assertEquals((long)133120L, (long)table.hopBits(index));
        }
    }

    @Test
    public void shouldClearTable() throws Exception {
        try (Table table = this.factory.newTable(16);){
            int index = 3;
            long key = 123L;
            Object value = this.factory.sampleValue();
            table.put(index, key, value);
            Assert.assertEquals((long)key, (long)table.key(index));
            table.clear();
            Assert.assertEquals((long)table.nullKey(), (long)table.key(index));
        }
    }

    private static interface TableFactory {
        public Table newTable(int var1);

        public Object sampleValue();

        public boolean supportsLongs();
    }
}

