/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import org.neo4j.metrics.source.jvm.JvmMetrics;

public class MemoryPoolMetrics
extends JvmMetrics {
    public static final String MEMORY_POOL = MetricRegistry.name((String)"vm", (String[])new String[]{"memory.pool"});
    private final MetricRegistry registry;

    public MemoryPoolMetrics(MetricRegistry registry) {
        this.registry = registry;
    }

    public void start() {
        for (MemoryPoolMXBean memPool : ManagementFactory.getMemoryPoolMXBeans()) {
            this.registry.register(MetricRegistry.name((String)MEMORY_POOL, (String[])new String[]{MemoryPoolMetrics.prettifyName(memPool.getName())}), (Metric)((Gauge)() -> memPool.getUsage().getUsed()));
        }
    }

    public void stop() {
        this.registry.removeMatching((name, metric) -> name.startsWith(MEMORY_POOL));
    }
}

