/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import org.neo4j.metrics.source.jvm.JvmMetrics;

public class MemoryBuffersMetrics
extends JvmMetrics {
    public static final String MEMORY_BUFFER = MetricRegistry.name((String)"vm", (String[])new String[]{"memory.buffer"});
    private final MetricRegistry registry;

    public MemoryBuffersMetrics(MetricRegistry registry) {
        this.registry = registry;
    }

    public void start() {
        for (BufferPoolMXBean pool : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            this.registry.register(MetricRegistry.name((String)MEMORY_BUFFER, (String[])new String[]{MemoryBuffersMetrics.prettifyName(pool.getName()), "count"}), (Metric)((Gauge)pool::getCount));
            this.registry.register(MetricRegistry.name((String)MEMORY_BUFFER, (String[])new String[]{MemoryBuffersMetrics.prettifyName(pool.getName()), "used"}), (Metric)((Gauge)pool::getMemoryUsed));
            this.registry.register(MetricRegistry.name((String)MEMORY_BUFFER, (String[])new String[]{MemoryBuffersMetrics.prettifyName(pool.getName()), "capacity"}), (Metric)((Gauge)pool::getTotalCapacity));
        }
    }

    public void stop() {
        this.registry.removeMatching((name, metric) -> name.startsWith(MEMORY_BUFFER));
    }
}

