/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.causalclustering;

import com.codahale.metrics.SlidingWindowReservoir;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.metrics.source.causalclustering.RaftMessageProcessingMetric;

public class RaftMessageProcessingMetricTest {
    private RaftMessageProcessingMetric metric = RaftMessageProcessingMetric.createUsing(() -> new SlidingWindowReservoir(1000));

    @Test
    public void shouldDefaultAllMessageTypesToEmptyTimer() {
        for (RaftMessages.Type type : RaftMessages.Type.values()) {
            Assert.assertEquals((long)0L, (long)this.metric.timer(type).getCount());
        }
        Assert.assertEquals((long)0L, (long)this.metric.timer().getCount());
    }

    @Test
    public void shouldBeAbleToUpdateAllMessageTypes() {
        int durationNanos = 5;
        double delta = 0.002;
        for (RaftMessages.Type type : RaftMessages.Type.values()) {
            this.metric.updateTimer(type, Duration.ofNanos(durationNanos));
            Assert.assertEquals((long)1L, (long)this.metric.timer(type).getCount());
            Assert.assertEquals((double)durationNanos, (double)this.metric.timer(type).getSnapshot().getMean(), (double)delta);
        }
        Assert.assertEquals((long)RaftMessages.Type.values().length, (long)this.metric.timer().getCount());
        Assert.assertEquals((double)durationNanos, (double)this.metric.timer().getSnapshot().getMean(), (double)delta);
    }

    @Test
    public void shouldDefaultDelayToZero() {
        Assert.assertEquals((long)0L, (long)this.metric.delay());
    }

    @Test
    public void shouldUpdateDelay() {
        this.metric.setDelay(Duration.ofMillis(5L));
        Assert.assertEquals((long)5L, (long)this.metric.delay());
    }
}

