/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.cluster.InstanceId;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.metrics.source.cluster.ClusterMetrics;

public class ClusterMetricsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final Monitors monitors = new Monitors();
    private final LifeSupport life = new LifeSupport();

    @Test
    public void clusterMetricsReportMasterAvailable() {
        Supplier<ClusterMembers> clusterMembers = ClusterMetricsTest.getClusterMembers("master", HighAvailabilityMemberState.MASTER);
        this.life.add((Lifecycle)new ClusterMetrics(this.monitors, this.metricRegistry, clusterMembers));
        this.life.start();
        TestReporter reporter = new TestReporter(this.metricRegistry);
        reporter.start(10L, TimeUnit.MILLISECONDS);
        reporter.report();
        Assert.assertEquals((long)1L, (long)reporter.isMasterValue);
        Assert.assertEquals((long)1L, (long)reporter.isAvailableValue);
    }

    @Test
    public void clusterMetricsReportSlaveAvailable() {
        Supplier<ClusterMembers> clusterMembers = ClusterMetricsTest.getClusterMembers("slave", HighAvailabilityMemberState.SLAVE);
        this.life.add((Lifecycle)new ClusterMetrics(this.monitors, this.metricRegistry, clusterMembers));
        this.life.start();
        TestReporter reporter = new TestReporter(this.metricRegistry);
        reporter.start(10L, TimeUnit.MILLISECONDS);
        reporter.report();
        Assert.assertEquals((long)0L, (long)reporter.isMasterValue);
        Assert.assertEquals((long)1L, (long)reporter.isAvailableValue);
    }

    private static Supplier<ClusterMembers> getClusterMembers(String memberRole, HighAvailabilityMemberState memberState) {
        HighAvailabilityMemberStateMachine stateMachine = (HighAvailabilityMemberStateMachine)Mockito.mock(HighAvailabilityMemberStateMachine.class);
        Mockito.when((Object)stateMachine.getCurrentState()).thenReturn((Object)memberState);
        ClusterMember clusterMember = (ClusterMember)Mockito.spy((Object)new ClusterMember(new InstanceId(1)));
        Mockito.when((Object)clusterMember.getHARole()).thenReturn((Object)memberRole);
        ObservedClusterMembers observedClusterMembers = (ObservedClusterMembers)Mockito.mock(ObservedClusterMembers.class);
        Mockito.when((Object)observedClusterMembers.getCurrentMember()).thenReturn((Object)clusterMember);
        return () -> new ClusterMembers(observedClusterMembers, stateMachine);
    }

    private class TestReporter
    extends ScheduledReporter {
        private int isMasterValue;
        private int isAvailableValue;

        protected TestReporter(MetricRegistry registry) {
            super(registry, "TestReporter", MetricFilter.ALL, TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS);
        }

        public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
            this.isMasterValue = (Integer)((Gauge)gauges.get(ClusterMetrics.IS_MASTER)).getValue();
            this.isAvailableValue = (Integer)((Gauge)gauges.get(ClusterMetrics.IS_AVAILABLE)).getValue();
        }
    }
}

