/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;
import org.neo4j.metrics.output.RotatableCsvReporter;
import org.neo4j.test.rule.TestDirectory;

public class RotatableCsvReporterTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private RotatingFileOutputStreamSupplier fileOutputStreamSupplier = (RotatingFileOutputStreamSupplier)Mockito.mock(RotatingFileOutputStreamSupplier.class);

    @Test
    public void stopAllWritersOnStop() throws IOException {
        Mockito.when((Object)this.fileOutputStreamSupplier.get()).thenReturn(Mockito.mock(OutputStream.class));
        RotatableCsvReporter reporter = new RotatableCsvReporter((MetricRegistry)Mockito.mock(MetricRegistry.class), Locale.US, TimeUnit.SECONDS, TimeUnit.SECONDS, Clock.defaultClock(), this.testDirectory.directory(), (file, rotationListener) -> this.fileOutputStreamSupplier);
        TreeMap<String, Gauge> gauges = new TreeMap<String, Gauge>();
        gauges.put("a", () -> ThreadLocalRandom.current().nextLong());
        gauges.put("b", () -> ThreadLocalRandom.current().nextLong());
        gauges.put("c", () -> ThreadLocalRandom.current().nextLong());
        reporter.report(gauges, new TreeMap(), new TreeMap(), new TreeMap(), new TreeMap());
        gauges.put("b", () -> ThreadLocalRandom.current().nextLong());
        gauges.put("c", () -> ThreadLocalRandom.current().nextLong());
        gauges.put("d", () -> ThreadLocalRandom.current().nextLong());
        reporter.report(gauges, new TreeMap(), new TreeMap(), new TreeMap(), new TreeMap());
        reporter.stop();
        ((RotatingFileOutputStreamSupplier)Mockito.verify((Object)this.fileOutputStreamSupplier, (VerificationMode)Mockito.times((int)4))).close();
    }
}

